/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.impl.redriver;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.UntypedActor;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.flux.client.runtime.FluxRuntimeConnector;
import com.flipkart.flux.domain.Status;
import com.flipkart.flux.impl.message.SerializedRedriverTask;
import com.flipkart.flux.impl.message.TaskAndEvents;
import com.flipkart.flux.impl.message.TaskRedriverDetails;
import com.flipkart.flux.impl.task.registry.RouterRegistry;
import javax.inject.Inject;

public class AkkaRedriverWorker
extends UntypedActor {
    private LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    @Inject
    private static FluxRuntimeConnector fluxRuntimeConnector;
    @Inject
    private static RouterRegistry routerRegistry;
    private static final ObjectMapper objectMapper;

    public void onReceive(Object message) throws Exception {
        if (message instanceof TaskRedriverDetails && ((TaskRedriverDetails)message).getAction().equals((Object)TaskRedriverDetails.RegisterAction.Redrive)) {
            Long taskId = ((TaskRedriverDetails)message).getTaskId();
            SerializedRedriverTask redriverTask = (SerializedRedriverTask)objectMapper.readValue(fluxRuntimeConnector.getSerializedRedriverTaskByTaskId(taskId), SerializedRedriverTask.class);
            TaskAndEvents taskAndEvents = redriverTask.getTaskAndEvents();
            if (taskAndEvents.getRetryCount() > taskAndEvents.getCurrentRetryCount() && this.isTaskRedrivable(redriverTask.getTaskStatus())) {
                this.logger.info("Redriver Task Worker is redriving a task with Id: {}", (Object)taskAndEvents.getTaskId());
                String taskIdentifier = taskAndEvents.getTaskIdentifier();
                int secondUnderscorePosition = taskIdentifier.indexOf(95, taskIdentifier.indexOf(95) + 1);
                String routerName = taskIdentifier.substring(0, secondUnderscorePosition == -1 ? taskIdentifier.length() : secondUnderscorePosition);
                ActorRef router = routerRegistry.getRouter(routerName);
                router.tell((Object)taskAndEvents, ActorRef.noSender());
            }
        } else {
            this.logger.error("Redriver Task Worker received a message that it cannot process (or) a non-redriver action. Message type received is : {}", (Object)message.getClass().getName());
            this.unhandled(message);
        }
    }

    private boolean isTaskRedrivable(Status taskStatus) {
        return !taskStatus.equals((Object)Status.completed) && !taskStatus.equals((Object)Status.sidelined) && !taskStatus.equals((Object)Status.errored) && !taskStatus.equals((Object)Status.cancelled);
    }

    static {
        objectMapper = new ObjectMapper();
    }
}

