/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.impl.task;

import com.flipkart.flux.api.EventData;
import com.flipkart.flux.api.core.Task;
import com.flipkart.flux.client.registry.Executable;
import com.flipkart.flux.client.registry.ExecutableRegistry;
import com.flipkart.flux.guice.annotation.ManagedEnv;
import com.flipkart.flux.impl.task.AbstractHook;
import com.flipkart.flux.impl.task.AbstractTask;
import com.flipkart.flux.impl.task.LocalJvmTask;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class TaskRegistry {
    private Map<String, AbstractTask> eventsToTaskMap = new ConcurrentHashMap<String, AbstractTask>();
    private Map<String, List<AbstractHook>> taskToPreExecHookMap = new ConcurrentHashMap<String, List<AbstractHook>>();
    private Map<String, List<AbstractHook>> taskToPostExecHookMap = new ConcurrentHashMap<String, List<AbstractHook>>();
    private final ExecutableRegistry executableRegistry;

    @Inject
    public TaskRegistry(@ManagedEnv ExecutableRegistry executableRegistry) {
        this.executableRegistry = executableRegistry;
    }

    public void registerTask(AbstractTask task, EventData[] events) {
        this.eventsToTaskMap.put(TaskRegistry.getEventsKey(events), task);
    }

    public List<AbstractHook> getPreExecHooks(Task task) {
        return this.taskToPreExecHookMap.get(task.getClass().getName());
    }

    public List<AbstractHook> getPostExecHooks(Task task) {
        return this.taskToPostExecHookMap.get(task.getClass().getName());
    }

    public void registerPreExecHooks(AbstractTask task, List<AbstractHook> hooks) {
        this.taskToPreExecHookMap.put(task.getClass().getName(), hooks);
    }

    public void registerPostExecHooks(AbstractTask task, List<AbstractHook> hooks) {
        this.taskToPostExecHookMap.put(task.getClass().getName(), hooks);
    }

    public static String getEventsKey(EventData[] events) {
        StringBuilder sb = new StringBuilder();
        for (EventData event : events) {
            sb.append(event.getClass().getName());
            sb.append("_");
        }
        return sb.toString();
    }

    public AbstractTask retrieveTask(String taskIdentifier) {
        Executable task = this.executableRegistry.getTask(taskIdentifier);
        return new LocalJvmTask(task);
    }
}

