/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.registry;

import com.flipkart.flux.client.intercept.MethodId;
import com.flipkart.flux.client.registry.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLClassLoader;

public class TaskExecutableImpl
implements Executable {
    private final Method toInvoke;
    private final Object singletonMethodOwner;
    private final long timeout;
    private final int executionConcurrency;
    private final Object objectMapperInstance;
    private final URLClassLoader deploymentUnitClassLoader;

    public TaskExecutableImpl(Object singletonMethodOwner, Method toInvoke, long timeout, int executionConcurrency, URLClassLoader classLoader, Object objectMapperInstance) {
        this.singletonMethodOwner = singletonMethodOwner;
        this.toInvoke = toInvoke;
        this.timeout = timeout;
        this.executionConcurrency = executionConcurrency;
        this.deploymentUnitClassLoader = classLoader;
        this.objectMapperInstance = objectMapperInstance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskExecutableImpl that = (TaskExecutableImpl)o;
        if (this.timeout != that.timeout) {
            return false;
        }
        if (!this.toInvoke.equals(that.toInvoke)) {
            return false;
        }
        return this.singletonMethodOwner.equals(that.singletonMethodOwner);
    }

    public int hashCode() {
        int result = this.toInvoke.hashCode();
        result = 31 * result + this.singletonMethodOwner.hashCode();
        result = 31 * result + (int)(this.timeout ^ this.timeout >>> 32);
        return result;
    }

    public String toString() {
        return "Executable{singletonMethodOwner=" + this.singletonMethodOwner + ", toInvoke=" + this.toInvoke + '}';
    }

    public String getName() {
        return new MethodId(this.toInvoke).getMethodName();
    }

    public long getTimeout() {
        return this.timeout;
    }

    public int getExecutionConcurrency() {
        return this.executionConcurrency;
    }

    public Object execute(Object[] parameters) {
        try {
            return this.toInvoke.invoke(this.singletonMethodOwner, parameters);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public Class<?>[] getParameterTypes() {
        return this.toInvoke.getParameterTypes();
    }

    public URLClassLoader getDeploymentUnitClassLoader() {
        return this.deploymentUnitClassLoader;
    }

    public Object getObjectMapperInstance() {
        return this.objectMapperInstance;
    }
}

