/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.impl.task;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.Terminated;
import akka.actor.UntypedActor;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import akka.routing.ActorRefRoutee;
import akka.routing.Routee;
import akka.routing.Router;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.flux.api.EventData;
import com.flipkart.flux.api.EventDefinition;
import com.flipkart.flux.api.ExecutionUpdateData;
import com.flipkart.flux.api.Status;
import com.flipkart.flux.api.core.FluxError;
import com.flipkart.flux.client.exception.FluxRetriableException;
import com.flipkart.flux.client.runtime.FluxRuntimeConnector;
import com.flipkart.flux.client.runtime.RuntimeCommunicationException;
import com.flipkart.flux.domain.Event;
import com.flipkart.flux.impl.message.HookAndEvents;
import com.flipkart.flux.impl.message.TaskAndEvents;
import com.flipkart.flux.impl.task.AbstractHook;
import com.flipkart.flux.impl.task.AbstractTask;
import com.flipkart.flux.impl.task.AkkaHook;
import com.flipkart.flux.impl.task.HookExecutor;
import com.flipkart.flux.impl.task.TaskExecutor;
import com.flipkart.flux.impl.task.TaskRegistry;
import com.netflix.hystrix.exception.HystrixRuntimeException;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;

public class AkkaTask
extends UntypedActor {
    private LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    @Inject
    private static TaskRegistry taskRegistry;
    @Inject
    private static FluxRuntimeConnector fluxRuntimeConnector;
    @Inject
    @Named(value="HookRouter")
    private Router hookRouter;
    private static final ObjectMapper objectMapper;

    public void onReceive(Object message) throws Exception {
        block19: {
            if (TaskAndEvents.class.isAssignableFrom(message.getClass())) {
                try {
                    AbstractTask task;
                    TaskAndEvents taskAndEvent = (TaskAndEvents)message;
                    this.logger.info("Akka task processing state machine: {} task: {}", (Object)taskAndEvent.getStateMachineId(), (Object)taskAndEvent.getTaskId());
                    this.logger.debug("Actor {} received directive {}", (Object)this.getSelf(), (Object)taskAndEvent);
                    if (!taskAndEvent.getIsFirstTimeExecution()) {
                        taskAndEvent.setCurrentRetryCount(taskAndEvent.getCurrentRetryCount() + 1L);
                        fluxRuntimeConnector.incrementExecutionRetries(taskAndEvent.getStateMachineId(), taskAndEvent.getTaskId());
                    }
                    if ((task = taskRegistry.retrieveTask(taskAndEvent.getTaskIdentifier())) != null) {
                        this.updateExecutionStatus(taskAndEvent, Status.running, null, false);
                        String outputEventName = this.getOutputEventName(taskAndEvent);
                        TaskExecutor taskExecutor = new TaskExecutor(task, taskAndEvent.getEvents(), taskAndEvent.getStateMachineId(), outputEventName);
                        Event outputEvent = null;
                        try {
                            outputEvent = (Event)taskExecutor.execute();
                            if (outputEvent != null) {
                                fluxRuntimeConnector.submitEvent(new EventData(outputEvent.getName(), outputEvent.getType(), outputEvent.getEventData(), outputEvent.getEventSource()), outputEvent.getStateMachineInstanceId());
                            }
                            this.updateExecutionStatus(taskAndEvent, Status.completed, null, true);
                            break block19;
                        }
                        catch (HystrixRuntimeException hre) {
                            HystrixRuntimeException.FailureType ft = hre.getFailureType();
                            if (ft.equals((Object)HystrixRuntimeException.FailureType.REJECTED_THREAD_EXECUTION) || ft.equals((Object)HystrixRuntimeException.FailureType.SHORTCIRCUIT) || ft.equals((Object)HystrixRuntimeException.FailureType.TIMEOUT)) {
                                this.updateExecutionStatus(taskAndEvent, Status.errored, ft.toString().toLowerCase(), false);
                                throw new FluxError(FluxError.ErrorType.timeout, ft.toString().toLowerCase(), null, false, new FluxError.ExecutionContextMeta(taskAndEvent.getStateMachineId(), taskAndEvent.getTaskId(), taskAndEvent.getRetryCount(), taskAndEvent.getCurrentRetryCount()));
                            }
                            boolean isFluxRetriableException = false;
                            Throwable cause = hre;
                            while (cause.getCause() != null || cause.getClass().getName().equals(FluxRetriableException.class.getName())) {
                                if (cause.getClass().getName().equals(FluxRetriableException.class.getName())) {
                                    isFluxRetriableException = true;
                                    break;
                                }
                                cause = cause.getCause();
                            }
                            if (isFluxRetriableException) {
                                this.updateExecutionStatus(taskAndEvent, Status.errored, cause.getClass().getName() + " : " + cause.getMessage(), false);
                                throw new FluxError(FluxError.ErrorType.retriable, cause.getClass().getName() + " : " + cause.getMessage(), null, false, new FluxError.ExecutionContextMeta(taskAndEvent.getStateMachineId(), taskAndEvent.getTaskId(), taskAndEvent.getRetryCount(), taskAndEvent.getCurrentRetryCount()));
                            }
                            this.updateExecutionStatus(taskAndEvent, Status.errored, cause.getClass().getName() + " : " + cause.getMessage(), true);
                            break block19;
                        }
                        catch (RuntimeCommunicationException e) {
                            this.logger.error("Task completed but updateStatus/submit failed. State machine: {} task: {} ErrorMsg: {}", (Object)taskAndEvent.getStateMachineId(), (Object)taskAndEvent.getTaskId(), (Object)e.getMessage());
                            this.updateExecutionStatus(taskAndEvent, Status.errored, e.getMessage(), false);
                            throw new FluxError(FluxError.ErrorType.retriable, e.getMessage(), e, false, new FluxError.ExecutionContextMeta(taskAndEvent.getStateMachineId(), taskAndEvent.getTaskId(), taskAndEvent.getRetryCount(), taskAndEvent.getCurrentRetryCount()));
                        }
                        catch (Exception e) {
                            this.updateExecutionStatus(taskAndEvent, Status.errored, e.getMessage(), true);
                            break block19;
                        }
                    }
                    this.logger.error("Task received EventS that it cannot process. State machine: {} task: {} Events received are : {}", (Object)taskAndEvent.getStateMachineId(), (Object)taskAndEvent.getTaskId(), (Object)TaskRegistry.getEventsKey(taskAndEvent.getEvents()));
                }
                catch (FluxError fe) {
                    if (!fe.getType().equals((Object)FluxError.ErrorType.timeout) && !fe.getType().equals((Object)FluxError.ErrorType.retriable)) break block19;
                    if (fe.getExecutionContextMeta().getAttemptedNoOfRetries() < fe.getExecutionContextMeta().getMaxRetries()) {
                        this.logger.info("Scheduling Task Id: {} for retry. Current retry count = {}, Cause = {} ", (Object)fe.getExecutionContextMeta().getTaskId(), (Object)fe.getExecutionContextMeta().getAttemptedNoOfRetries(), (Object)fe.getMessage());
                        ((TaskAndEvents)message).setFirstTimeExecution(false);
                        this.getContext().system().scheduler().scheduleOnce(FiniteDuration.create((long)((int)Math.pow(2.0, fe.getExecutionContextMeta().getAttemptedNoOfRetries() + 1L)), (TimeUnit)TimeUnit.SECONDS), this.getSelf(), message, (ExecutionContext)this.getContext().system().dispatcher(), null);
                        break block19;
                    }
                    this.logger.warning("Aborting retries for Task Id : {}. Retry count exceeded : {}", (Object)fe.getExecutionContextMeta().getTaskId(), (Object)fe.getExecutionContextMeta().getAttemptedNoOfRetries());
                    fluxRuntimeConnector.updateExecutionStatus(new ExecutionUpdateData(fe.getExecutionContextMeta().getStateMachineId(), fe.getExecutionContextMeta().getTaskId(), Status.sidelined, fe.getExecutionContextMeta().getMaxRetries().longValue(), fe.getExecutionContextMeta().getAttemptedNoOfRetries().longValue(), fe.getMessage(), true));
                }
            } else if (!HookExecutor.STATUS.class.isAssignableFrom(message.getClass())) {
                if (message instanceof Terminated) {
                    this.hookRouter = this.hookRouter.removeRoutee(((Terminated)message).actor());
                    ActorRef r = this.getContext().actorOf(Props.create(AkkaHook.class, (Object[])new Object[0]));
                    this.getContext().watch(r);
                    this.hookRouter = this.hookRouter.addRoutee((Routee)new ActorRefRoutee(r));
                } else {
                    this.logger.error("Task received a message that it cannot process. Only com.flipkart.flux.impl.message.TaskAndEvents is supported. Message type received is : {}", (Object)message.getClass().getName());
                    this.unhandled(message);
                }
            }
        }
    }

    private void executeHooks(List<AbstractHook> hooks, EventData[] events) {
        if (hooks != null) {
            for (AbstractHook hook : hooks) {
                HookAndEvents hookAndEvents = new HookAndEvents(hook, events);
                this.hookRouter.route((Object)hookAndEvents, this.getSelf());
            }
        }
    }

    private String getOutputEventName(TaskAndEvents taskAndEvent) throws IOException {
        String outputEvent = taskAndEvent.getOutputEvent();
        return outputEvent != null ? ((EventDefinition)objectMapper.readValue(outputEvent, EventDefinition.class)).getName() : null;
    }

    private void updateExecutionStatus(TaskAndEvents taskAndEvent, Status status, String errorMsg, boolean deleteFromRedriver) {
        fluxRuntimeConnector.updateExecutionStatus(new ExecutionUpdateData(taskAndEvent.getStateMachineId(), taskAndEvent.getTaskId(), status, taskAndEvent.getRetryCount(), taskAndEvent.getCurrentRetryCount(), errorMsg, deleteFromRedriver));
    }

    static {
        objectMapper = new ObjectMapper();
    }
}

