/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.impl.redriver;

import akka.actor.ActorSystem;
import akka.actor.PoisonPill;
import akka.actor.Props;
import akka.cluster.singleton.ClusterSingletonManager;
import akka.cluster.singleton.ClusterSingletonManagerSettings;
import com.flipkart.flux.client.runtime.FluxRuntimeConnector;
import com.flipkart.flux.impl.boot.ActorSystemManager;
import com.flipkart.flux.impl.redriver.AkkaRedriverService;
import com.flipkart.flux.redriver.model.ScheduledMessage;
import com.flipkart.flux.redriver.service.MessageManagerService;
import com.flipkart.flux.redriver.service.RedriverService;
import com.flipkart.flux.task.redriver.RedriverRegistry;
import com.flipkart.polyguice.core.Initializable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

@Singleton
public class RedriverRegistryImpl
implements RedriverRegistry,
Initializable {
    private static final Logger logger = LoggerFactory.getLogger(RedriverRegistryImpl.class);
    ActorSystemManager actorSystemManager;
    private FluxRuntimeConnector fluxRuntimeConnector;
    private MessageManagerService redriverMessageService;
    private RedriverService redriverService;

    @Inject
    public RedriverRegistryImpl(ActorSystemManager actorSystemManager, FluxRuntimeConnector fluxRuntimeConnector, MessageManagerService redriverMessageService, RedriverService redriverService) {
        this.actorSystemManager = actorSystemManager;
        this.fluxRuntimeConnector = fluxRuntimeConnector;
        this.redriverMessageService = redriverMessageService;
        this.redriverService = redriverService;
    }

    public void initialize() {
        ActorSystem actorSystem = this.actorSystemManager.retrieveActorSystem();
        Props actorProps = Props.create(AkkaRedriverService.class, (Object[])new Object[]{this.redriverService});
        ClusterSingletonManagerSettings settings = ClusterSingletonManagerSettings.create((ActorSystem)actorSystem);
        actorSystem.actorOf(ClusterSingletonManager.props((Props)actorProps, (Object)PoisonPill.getInstance(), (ClusterSingletonManagerSettings)settings), "redriverServiceActor");
    }

    public void registerTask(Long taskId, long redriveDelay) {
        logger.debug("Register task : {} for redriver with time : {}", (Object)taskId, (Object)redriveDelay);
        this.redriverMessageService.saveMessage(new ScheduledMessage(taskId, Long.valueOf(System.currentTimeMillis() + redriveDelay)));
    }

    public void deRegisterTask(Long taskId) {
        MDC.put((String)"taskId", (String)taskId.toString());
        logger.debug("DeRegister task : {} with redriver", (Object)taskId);
        this.redriverMessageService.scheduleForRemoval(taskId);
    }

    public void redriveTask(Long taskId) {
        MDC.put((String)"taskId", (String)taskId.toString());
        logger.debug("Redrive task with Id : {} ", (Object)taskId);
        this.fluxRuntimeConnector.redriveTask(taskId);
    }
}

