/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.api.core;

public class FluxError
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private static final boolean DEFAULT_FILL_IN_STACK_TRACE = true;
    private ErrorType type;
    private boolean fillInStackTrace = true;
    private ExecutionContextMeta executionContextMeta;

    public FluxError(ErrorType type, String errorMessage, Throwable rootCause) {
        super(errorMessage, rootCause);
        this.type = type;
    }

    public FluxError(ErrorType type, String errorMessage, Throwable rootCause, boolean fillInStackTrace) {
        this(type, errorMessage, rootCause);
        this.fillInStackTrace = fillInStackTrace;
    }

    public FluxError(ErrorType type, String errorMessage, Throwable rootCause, boolean fillInStackTrace, ExecutionContextMeta executionContextMeta) {
        this(type, errorMessage, rootCause, fillInStackTrace);
        this.executionContextMeta = executionContextMeta;
    }

    @Override
    public Throwable fillInStackTrace() {
        if (!this.fillInStackTrace) {
            return null;
        }
        return super.fillInStackTrace();
    }

    public ErrorType getType() {
        return this.type;
    }

    public void setType(ErrorType type) {
        this.type = type;
    }

    public ExecutionContextMeta getExecutionContextMeta() {
        return this.executionContextMeta;
    }

    public static class ExecutionContextMeta {
        private Long stateMachineId;
        private String stateMachineName;
        private String taskName;
        private Long taskId;
        private Long maxRetries;
        private Long attemptedNoOfRetries;

        public ExecutionContextMeta(Long stateMachineId, String stateMachineName, String taskName, Long taskId, Long maxRetries, Long attemptedNoOfRetries) {
            this.stateMachineId = stateMachineId;
            this.stateMachineName = stateMachineName;
            this.taskName = taskName;
            this.taskId = taskId;
            this.maxRetries = maxRetries;
            this.attemptedNoOfRetries = attemptedNoOfRetries;
        }

        public Long getStateMachineId() {
            return this.stateMachineId;
        }

        public String getStateMachineName() {
            return this.stateMachineName;
        }

        public String getTaskName() {
            return this.taskName;
        }

        public Long getTaskId() {
            return this.taskId;
        }

        public Long getMaxRetries() {
            return this.maxRetries;
        }

        public Long getAttemptedNoOfRetries() {
            return this.attemptedNoOfRetries;
        }
    }

    public static enum ErrorType {
        runtime,
        timeout,
        retriable;

    }
}

