/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.impl.task.registry;

import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.actor.UntypedActor;
import akka.cluster.Cluster;
import akka.cluster.ClusterEvent;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import java.util.List;

public class ClusterListener
extends UntypedActor {
    private LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private Cluster cluster = Cluster.get((ActorSystem)this.getContext().system());
    private List<Address> memberAddresses;

    public ClusterListener(List<Address> memberAddresses) {
        this.memberAddresses = memberAddresses;
    }

    public void preStart() {
        this.cluster.subscribe(this.getSelf(), (ClusterEvent.SubscriptionInitialStateMode)ClusterEvent.initialStateAsEvents(), new Class[]{ClusterEvent.MemberEvent.class, ClusterEvent.UnreachableMember.class});
    }

    public void postStop() {
        this.cluster.unsubscribe(this.getSelf());
    }

    public void onReceive(Object message) {
        if (message instanceof ClusterEvent.MemberUp) {
            ClusterEvent.MemberUp mUp = (ClusterEvent.MemberUp)message;
            this.logger.info("Cluster Member is Up: " + mUp.member());
            this.memberAddresses.add(mUp.member().address());
        } else if (message instanceof ClusterEvent.UnreachableMember) {
            ClusterEvent.UnreachableMember mUnreachable = (ClusterEvent.UnreachableMember)message;
            this.logger.info("Cluster Member detected as unreachable " + mUnreachable.member());
        } else if (message instanceof ClusterEvent.MemberRemoved) {
            ClusterEvent.MemberRemoved mRemoved = (ClusterEvent.MemberRemoved)message;
            this.logger.info("Cluster Member is Removed: " + mRemoved.member());
            this.memberAddresses.remove(mRemoved.member().address());
        } else if (!(message instanceof ClusterEvent.MemberEvent)) {
            this.unhandled(message);
        }
    }
}

