/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.impl.redriver;

import akka.actor.ActorSystem;
import akka.actor.PoisonPill;
import akka.actor.Props;
import akka.cluster.singleton.ClusterSingletonManager;
import akka.cluster.singleton.ClusterSingletonManagerSettings;
import com.flipkart.flux.client.runtime.FluxRuntimeConnector;
import com.flipkart.flux.impl.boot.ActorSystemManager;
import com.flipkart.flux.impl.redriver.AkkaRedriverService;
import com.flipkart.flux.redriver.model.ScheduledMessage;
import com.flipkart.flux.redriver.service.MessageManagerService;
import com.flipkart.flux.redriver.service.RedriverService;
import com.flipkart.flux.task.redriver.RedriverRegistry;
import com.flipkart.flux.utils.LoggingUtils;
import com.flipkart.polyguice.core.Initializable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class RedriverRegistryImpl
implements RedriverRegistry,
Initializable {
    private static final Logger logger = LogManager.getLogger(RedriverRegistryImpl.class);
    ActorSystemManager actorSystemManager;
    private FluxRuntimeConnector fluxRuntimeConnector;
    private MessageManagerService redriverMessageService;
    private RedriverService redriverService;

    @Inject
    public RedriverRegistryImpl(ActorSystemManager actorSystemManager, FluxRuntimeConnector fluxRuntimeConnector, MessageManagerService redriverMessageService, RedriverService redriverService) {
        this.actorSystemManager = actorSystemManager;
        this.fluxRuntimeConnector = fluxRuntimeConnector;
        this.redriverMessageService = redriverMessageService;
        this.redriverService = redriverService;
    }

    public void initialize() {
        ActorSystem actorSystem = this.actorSystemManager.retrieveActorSystem();
        Props actorProps = Props.create(AkkaRedriverService.class, (Object[])new Object[]{this.redriverService});
        ClusterSingletonManagerSettings settings = ClusterSingletonManagerSettings.create((ActorSystem)actorSystem);
        actorSystem.actorOf(ClusterSingletonManager.props((Props)actorProps, (Object)PoisonPill.getInstance(), (ClusterSingletonManagerSettings)settings), "redriverServiceActor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTask(Long taskId, String stateMachineId, long redriveDelay, Long executionVersion) {
        try {
            LoggingUtils.registerStateMachineIdForLogging((String)stateMachineId.toString());
            logger.info("Register task : {} for redriver with time : {}", (Object)taskId, (Object)redriveDelay);
            this.redriverMessageService.saveMessage(new ScheduledMessage(taskId, stateMachineId, Long.valueOf(System.currentTimeMillis() + redriveDelay), executionVersion));
        }
        finally {
            LoggingUtils.deRegisterStateMachineIdForLogging();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deRegisterTask(String stateMachineId, Long taskId, Long executionVersion) {
        try {
            LoggingUtils.registerStateMachineIdForLogging((String)stateMachineId.toString());
            logger.info("DeRegister task : {} with smId : {} redriver", (Object)taskId, (Object)stateMachineId);
            this.redriverMessageService.scheduleForRemoval(stateMachineId, taskId, executionVersion);
        }
        finally {
            LoggingUtils.deRegisterStateMachineIdForLogging();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redriveTask(String stateMachineId, Long taskId, Long executionVersion) {
        try {
            LoggingUtils.registerStateMachineIdForLogging((String)stateMachineId.toString());
            logger.info("Redrive task with stateMachineId: {} Id : {} and executionVersion: {}", (Object)stateMachineId, (Object)taskId, (Object)executionVersion);
            this.fluxRuntimeConnector.redriveTask(stateMachineId, taskId, executionVersion);
        }
        finally {
            LoggingUtils.deRegisterStateMachineIdForLogging();
        }
    }
}

