/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.impl.eventscheduler;

import akka.actor.ActorSystem;
import akka.actor.PoisonPill;
import akka.actor.Props;
import akka.cluster.singleton.ClusterSingletonManager;
import akka.cluster.singleton.ClusterSingletonManagerSettings;
import com.flipkart.flux.client.runtime.FluxRuntimeConnector;
import com.flipkart.flux.eventscheduler.dao.EventSchedulerDao;
import com.flipkart.flux.eventscheduler.model.ScheduledEvent;
import com.flipkart.flux.eventscheduler.service.EventSchedulerService;
import com.flipkart.flux.impl.boot.ActorSystemManager;
import com.flipkart.flux.impl.eventscheduler.AkkaEventSchedulerService;
import com.flipkart.flux.task.eventscheduler.EventSchedulerRegistry;
import com.flipkart.polyguice.core.Initializable;
import com.google.inject.Singleton;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class EventSchedulerRegistryImpl
implements EventSchedulerRegistry,
Initializable {
    private static final Logger logger = LogManager.getLogger(EventSchedulerRegistryImpl.class);
    private ActorSystemManager actorSystemManager;
    private EventSchedulerService eventSchedulerService;
    private FluxRuntimeConnector fluxRuntimeConnector;
    private EventSchedulerDao eventSchedulerDao;

    @Inject
    public EventSchedulerRegistryImpl(ActorSystemManager actorSystemManager, EventSchedulerService eventSchedulerService, FluxRuntimeConnector fluxRuntimeConnector, EventSchedulerDao eventSchedulerDao) {
        this.actorSystemManager = actorSystemManager;
        this.eventSchedulerService = eventSchedulerService;
        this.fluxRuntimeConnector = fluxRuntimeConnector;
        this.eventSchedulerDao = eventSchedulerDao;
    }

    public void initialize() {
        ActorSystem actorSystem = this.actorSystemManager.retrieveActorSystem();
        Props actorProps = Props.create(AkkaEventSchedulerService.class, (Object[])new Object[]{this.eventSchedulerService});
        ClusterSingletonManagerSettings settings = ClusterSingletonManagerSettings.create((ActorSystem)actorSystem);
        actorSystem.actorOf(ClusterSingletonManager.props((Props)actorProps, (Object)PoisonPill.getInstance(), (ClusterSingletonManagerSettings)settings), "eventSchedulerServiceActor");
    }

    public void registerEvent(String correlationId, String eventName, String eventData, Long scheduledTime) {
        logger.info("Saving event: {} for state machine: {} with scheduledtime: {}", (Object)eventName, (Object)correlationId, (Object)scheduledTime);
        this.eventSchedulerDao.save(new ScheduledEvent(correlationId, eventName, scheduledTime.longValue(), eventData));
    }

    public void deregisterEvent(String correlationId, String eventName) {
        logger.info("Deleting event: {} of state machine: {}", (Object)eventName, (Object)correlationId);
        this.eventSchedulerDao.delete(correlationId, eventName);
    }

    public void triggerEvent(String eventName, Object data, String correlationId, String eventSource) {
        logger.info("Triggering event: {} for state machine: {}", (Object)eventName, (Object)correlationId);
        this.fluxRuntimeConnector.submitScheduledEvent(eventName, data, correlationId, eventSource, null);
    }
}

