/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.flux.registry;

import com.flipkart.flux.client.registry.Executable;
import com.flipkart.flux.client.registry.ExecutableRegistry;
import com.flipkart.flux.registry.TaskNotFoundException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class TaskExecutableRegistryImpl
implements ExecutableRegistry {
    private final Map<String, Executable> identifierToMethodMap = new ConcurrentHashMap<String, Executable>();

    @Inject
    public TaskExecutableRegistryImpl() {
    }

    public Executable getTask(String taskIdentifier) {
        Executable cachedExecutable = this.identifierToMethodMap.get(taskIdentifier);
        if (cachedExecutable == null) {
            throw new TaskNotFoundException("Did not find task identifier:" + taskIdentifier + " in identifierToMethodMap, seems it didn't get registered. Something terribly went wrong!");
        }
        return cachedExecutable;
    }

    public Method getHook(String hookIdentifier) {
        return null;
    }

    public void registerTask(String taskIdentifier, Executable method) {
        this.identifierToMethodMap.put(taskIdentifier, method);
    }

    public void unregisterTask(String taskIdentifier) {
        this.identifierToMethodMap.remove(taskIdentifier);
    }
}

