/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.client.cluster;

import com.flipkart.foxtrot.client.FoxtrotClientConfig;
import com.flipkart.foxtrot.client.MemberSelector;
import com.flipkart.foxtrot.client.cluster.ClusterStatusUpdater;
import com.flipkart.foxtrot.client.cluster.FoxtrotClusterMember;
import com.flipkart.foxtrot.client.cluster.FoxtrotClusterStatus;
import com.flipkart.foxtrot.client.serialization.FoxtrotClusterResponseSerializationHandler;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FoxtrotCluster {
    private static final Logger logger = LoggerFactory.getLogger((String)FoxtrotCluster.class.getSimpleName());
    private final MemberSelector selector;
    private final ScheduledFuture<?> future;
    private ScheduledExecutorService executorService;
    private AtomicReference<FoxtrotClusterStatus> status = new AtomicReference();

    public FoxtrotCluster(FoxtrotClientConfig config, MemberSelector selector, FoxtrotClusterResponseSerializationHandler serializationHandler) throws Exception {
        this.selector = selector;
        this.executorService = Executors.newScheduledThreadPool(1);
        ClusterStatusUpdater updater = ClusterStatusUpdater.create(config, this.status, serializationHandler);
        updater.loadClusterData();
        this.future = this.executorService.scheduleWithFixedDelay(updater, config.getRefreshIntervalSecs(), config.getRefreshIntervalSecs(), TimeUnit.SECONDS);
    }

    public FoxtrotClusterMember member() {
        if (null == this.status) {
            return null;
        }
        FoxtrotClusterStatus foxtrotClusterStatus = this.status.get();
        if (null == foxtrotClusterStatus || foxtrotClusterStatus.getMembers().isEmpty()) {
            return null;
        }
        return this.selector.selectMember(foxtrotClusterStatus.getMembers());
    }

    public void stop() {
        logger.debug("Shutting down cluster status checker");
        this.future.cancel(true);
        while (!this.future.isDone()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                logger.error("Interrupted", (Throwable)e);
            }
            logger.debug("Waiting for checker to stop");
        }
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            logger.error("executor_service_termination_exception", (Throwable)e);
        }
        this.executorService.shutdownNow();
        logger.debug("Shut down cluster status checker");
    }
}

