/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.client.senders;

import com.flipkart.foxtrot.client.Document;
import com.flipkart.foxtrot.client.EventSender;
import com.flipkart.foxtrot.client.EventSerializationHandler;
import com.flipkart.foxtrot.client.FoxtrotClientConfig;
import com.flipkart.foxtrot.client.cluster.FoxtrotCluster;
import com.flipkart.foxtrot.client.cluster.FoxtrotClusterMember;
import com.flipkart.foxtrot.client.serialization.SerializationException;
import com.google.common.base.Preconditions;
import com.google.common.net.MediaType;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSyncEventSender
extends EventSender {
    private static final Logger logger = LoggerFactory.getLogger((String)HttpSyncEventSender.class.getSimpleName());
    private final String table;
    private final FoxtrotCluster client;
    private CloseableHttpClient httpClient;

    public HttpSyncEventSender(FoxtrotClientConfig config, FoxtrotCluster client, EventSerializationHandler serializationHandler) {
        super(serializationHandler);
        this.table = config.getTable();
        this.client = client;
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(1024);
        cm.setDefaultMaxPerRoute(1);
        this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
    }

    @Override
    public void send(Document document) {
        this.send(Collections.singletonList(document));
    }

    @Override
    public void send(List<Document> documents) {
        try {
            this.send(this.getSerializationHandler().serialize(documents));
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws Exception {
        this.httpClient.close();
        logger.debug("Closed HTTP Client");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(byte[] payload) {
        FoxtrotClusterMember clusterMember = this.client.member();
        Preconditions.checkNotNull((Object)clusterMember, (Object)"No members found in foxtrot cluster");
        CloseableHttpResponse response = null;
        try {
            URI requestURI = new URIBuilder().setScheme("http").setHost(clusterMember.getHost()).setPort(clusterMember.getPort()).setPath(String.format("/foxtrot/v1/document/%s/bulk", this.table)).build();
            HttpPost post = new HttpPost(requestURI);
            post.setHeader("Content-Type", MediaType.JSON_UTF_8.toString());
            post.setEntity((HttpEntity)new ByteArrayEntity(payload));
            response = this.httpClient.execute((HttpUriRequest)post);
            if (response.getStatusLine().getStatusCode() != 201) {
                throw new RuntimeException("Could not send event: " + EntityUtils.toString((HttpEntity)response.getEntity()));
            }
            logger.debug("Published event to {}:{}", (Object)clusterMember.getHost(), (Object)clusterMember.getPort());
        }
        catch (IOException | URISyntaxException e) {
            logger.error("Unable to publish event to foxtrot", (Throwable)e);
        }
        finally {
            if (null != response) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

