/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.client.senders;

import com.flipkart.foxtrot.client.Document;
import com.flipkart.foxtrot.client.EventSender;
import com.flipkart.foxtrot.client.FoxtrotClientConfig;
import com.flipkart.foxtrot.client.cluster.FoxtrotCluster;
import com.flipkart.foxtrot.client.cluster.FoxtrotClusterMember;
import com.flipkart.foxtrot.client.selectors.FoxtrotTarget;
import com.flipkart.foxtrot.client.senders.FoxtrotHttpClient;
import com.flipkart.foxtrot.client.serialization.EventSerializationHandler;
import com.flipkart.foxtrot.client.serialization.SerializationException;
import com.google.common.base.Preconditions;
import com.squareup.okhttp.ConnectionPool;
import com.squareup.okhttp.OkHttpClient;
import feign.Client;
import feign.Feign;
import feign.FeignException;
import feign.Logger;
import feign.Response;
import feign.slf4j.Slf4jLogger;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSyncEventSender
extends EventSender {
    private static final Logger logger = LoggerFactory.getLogger((String)HttpSyncEventSender.class.getSimpleName());
    private final String table;
    private final FoxtrotCluster client;
    private FoxtrotHttpClient httpClient;
    private static final Slf4jLogger slf4jLogger = new Slf4jLogger();

    public HttpSyncEventSender(FoxtrotClientConfig config, FoxtrotCluster client, EventSerializationHandler serializationHandler) {
        super(serializationHandler);
        this.table = config.getTable();
        this.client = client;
        OkHttpClient okHttpClient = new OkHttpClient();
        okHttpClient.setConnectionPool(new ConnectionPool(config.getMaxConnections(), config.getKeepAliveTimeMillis()));
        this.httpClient = (FoxtrotHttpClient)Feign.builder().client((Client)new feign.okhttp.OkHttpClient(okHttpClient)).logger((feign.Logger)slf4jLogger).logLevel(Logger.Level.BASIC).target(new FoxtrotTarget<FoxtrotHttpClient>(FoxtrotHttpClient.class, "foxtrot", client));
    }

    @Override
    public void send(Document document) {
        this.send(Collections.singletonList(document));
    }

    @Override
    public void send(List<Document> documents) {
        try {
            this.send(this.getSerializationHandler().serialize(documents));
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws Exception {
    }

    public void send(byte[] payload) {
        FoxtrotClusterMember clusterMember = this.client.member();
        Preconditions.checkNotNull((Object)clusterMember, (Object)"No members found in foxtrot cluster");
        try {
            Response response = this.httpClient.send(this.table, payload);
            if (response.status() != 201) {
                throw new RuntimeException(String.format("table=%s event_send_failed status [%d] exception_message=%s", this.table, response.status(), response.reason()));
            }
            logger.info("table={} messages_sent host={} port={}", new Object[]{this.table, clusterMember.getHost(), clusterMember.getPort()});
        }
        catch (FeignException e) {
            logger.error("table={} event_publish_failed", (Object)new Object[]{this.table}, (Object)e);
        }
    }
}

