/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.compare.handlers.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.flipkart.compare.TestCompareException;
import com.flipkart.compare.diff.DiffDetail;
import com.flipkart.compare.diff.DiffType;
import com.flipkart.compare.handlers.TestCompareHandler;
import com.flipkart.compare.handlers.json.JsonTestCompareHandlerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonTestCompareHandler
extends TestCompareHandler {
    private static final Logger logger = LoggerFactory.getLogger(JsonTestCompareHandler.class);
    private static final ObjectMapper mapper = new ObjectMapper();

    @Override
    protected void doCompare(byte[] profiledData, byte[] testData) throws TestCompareException {
        block14: {
            try {
                DiffDetail diffDetail;
                if (profiledData == null && testData == null || profiledData != null && profiledData.length == 0 && testData.length == 0) {
                    return;
                }
                if (profiledData == null || testData == null) {
                    DiffDetail diffDetail2 = this.getDiffDetail(null, profiledData == null ? null : new String(profiledData), testData == null ? null : new String(testData), DiffType.MODIFY);
                    if (diffDetail2 != null) {
                        throw new TestCompareException(Arrays.asList(diffDetail2));
                    }
                    return;
                }
                JsonNode expectedNode = mapper.readTree(profiledData);
                JsonNode actualNode = mapper.readTree(testData);
                if (expectedNode.isArray() && actualNode.isArray()) {
                    ArrayList<DiffDetail> diffs = new ArrayList<DiffDetail>();
                    this.compute((ArrayNode)expectedNode, (ArrayNode)actualNode, (List<DiffDetail>)diffs, "/");
                    for (DiffDetail diffDetail3 : diffs) {
                        logger.info("diff type: " + (Object)((Object)diffDetail3.getDiffType()) + ", diff path: " + diffDetail3.getDiffPath());
                    }
                    if (diffs.size() > 0) {
                        throw new TestCompareException(diffs);
                    }
                } else if (expectedNode.isObject() && actualNode.isObject()) {
                    ArrayList<DiffDetail> diffs = new ArrayList<DiffDetail>();
                    this.compute((ObjectNode)expectedNode, (ObjectNode)actualNode, (List<DiffDetail>)diffs, "/");
                    for (DiffDetail diffDetail4 : diffs) {
                        logger.info("diff type: " + (Object)((Object)diffDetail4.getDiffType()) + ", diff path: " + diffDetail4.getDiffPath());
                    }
                    if (diffs.size() > 0) {
                        throw new TestCompareException(diffs);
                    }
                } else if (!Arrays.equals(profiledData, testData) && (diffDetail = this.getDiffDetail("/", new String(profiledData), new String(testData), DiffType.MODIFY)) != null) {
                    throw new TestCompareException(Arrays.asList(diffDetail));
                }
            }
            catch (IOException e) {
                DiffDetail diffDetail;
                if (Arrays.equals(profiledData, testData) || (diffDetail = this.getDiffDetail("/", new String(profiledData), new String(testData), DiffType.MODIFY)) == null) break block14;
                throw new TestCompareException(Arrays.asList(diffDetail));
            }
        }
    }

    private void compute(ArrayNode expectedArray, ArrayNode actualArray, List<DiffDetail> diffs, String diffKey) {
        DiffDetail diffDetail;
        int i;
        int i2;
        HashMap<Integer, Integer> mappedExpectedToActual = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> mappedActualToExpected = new HashMap<Integer, Integer>();
        block0: for (int i3 = 0; i3 < expectedArray.size(); ++i3) {
            for (int j = 0; j < actualArray.size(); ++j) {
                DiffDetail diff;
                if (mappedActualToExpected.containsKey(j)) continue;
                JsonNode expectedObject = expectedArray.get(i3);
                JsonNode actualObject = actualArray.get(j);
                ArrayList<DiffDetail> newDiffs = new ArrayList<DiffDetail>();
                this.compute(expectedObject, actualObject, newDiffs, diffKey + ", (.*)");
                if (newDiffs.size() > 0) continue;
                mappedExpectedToActual.put(i3, j);
                mappedActualToExpected.put(j, i3);
                if (i3 == j || (diff = this.getDiffDetail(diffKey + ", (.*), /", expectedObject, actualObject, DiffType.MOVE)) == null) continue block0;
                diffs.add(diff);
                continue block0;
            }
        }
        ArrayList<Integer> notMappedExpectedObjectNodesIndexList = new ArrayList<Integer>();
        ArrayList<Integer> notMappedActualObjectNodesIndexList = new ArrayList<Integer>();
        HashMap notMappedExpectedToPotentialActualObjectNodesMapForDiffComp = new HashMap();
        for (i2 = 0; i2 < expectedArray.size(); ++i2) {
            if (mappedExpectedToActual.containsKey(i2) || !expectedArray.get(i2).isObject()) continue;
            notMappedExpectedObjectNodesIndexList.add(i2);
        }
        for (i2 = 0; i2 < actualArray.size(); ++i2) {
            if (mappedActualToExpected.containsKey(i2) || !actualArray.get(i2).isObject()) continue;
            notMappedActualObjectNodesIndexList.add(i2);
        }
        for (Integer notMappedExpectedObjectNodeIndex : notMappedExpectedObjectNodesIndexList) {
            String[] expectedKeys = JsonTestCompareHandlerUtil.getObjectKeys((ObjectNode)expectedArray.get(notMappedExpectedObjectNodeIndex.intValue()));
            for (Integer notMappedActualObjectNodeIndex : notMappedActualObjectNodesIndexList) {
                String[] actualKeys = JsonTestCompareHandlerUtil.getObjectKeys((ObjectNode)actualArray.get(notMappedActualObjectNodeIndex.intValue()));
                if (!JsonTestCompareHandlerUtil.allExpectedKeysInActualKeys(expectedKeys, actualKeys)) continue;
                if (notMappedExpectedToPotentialActualObjectNodesMapForDiffComp.containsKey(notMappedExpectedObjectNodeIndex)) {
                    ((List)notMappedExpectedToPotentialActualObjectNodesMapForDiffComp.get(notMappedExpectedObjectNodeIndex)).add(notMappedActualObjectNodeIndex);
                    continue;
                }
                ArrayList<Integer> potentialActualNodeIndexList = new ArrayList<Integer>();
                potentialActualNodeIndexList.add(notMappedActualObjectNodeIndex);
                notMappedExpectedToPotentialActualObjectNodesMapForDiffComp.put(notMappedExpectedObjectNodeIndex, potentialActualNodeIndexList);
            }
        }
        for (i = 0; i < expectedArray.size(); ++i) {
            if (mappedExpectedToActual.containsKey(i)) continue;
            HashMap<Integer, ArrayList<DiffDetail>> mapOfAllDiffDetails = new HashMap<Integer, ArrayList<DiffDetail>>();
            for (int j = 0; j < actualArray.size(); ++j) {
                if (mappedActualToExpected.containsKey(j) || notMappedExpectedToPotentialActualObjectNodesMapForDiffComp.containsKey(i) && !((List)notMappedExpectedToPotentialActualObjectNodesMapForDiffComp.get(i)).contains(j)) continue;
                JsonNode actualObject = actualArray.get(j);
                JsonNode expectedObject = expectedArray.get(i);
                ArrayList<DiffDetail> newDiffs = new ArrayList<DiffDetail>();
                this.compute(expectedObject, actualObject, newDiffs, diffKey + ", (.*)");
                if (newDiffs.size() > 0) {
                    mapOfAllDiffDetails.put(j, newDiffs);
                    continue;
                }
                mappedExpectedToActual.put(i, j);
                mappedActualToExpected.put(j, i);
            }
            if (mapOfAllDiffDetails.size() <= 0) continue;
            List minDiffDetail = (List)mapOfAllDiffDetails.entrySet().iterator().next().getValue();
            Integer j = (Integer)mapOfAllDiffDetails.entrySet().iterator().next().getKey();
            for (Map.Entry diffDetailsEntry : mapOfAllDiffDetails.entrySet()) {
                if (((List)diffDetailsEntry.getValue()).size() >= minDiffDetail.size()) continue;
                minDiffDetail = (List)diffDetailsEntry.getValue();
                j = (Integer)diffDetailsEntry.getKey();
            }
            diffs.addAll(minDiffDetail);
            mappedActualToExpected.put(j, i);
            mappedExpectedToActual.put(i, j);
        }
        for (int j = 0; j < actualArray.size(); ++j) {
            if (mappedActualToExpected.containsKey(j) || (diffDetail = this.getDiffDetail(diffKey + ", (.*), /", null, actualArray.get(j), DiffType.MODIFY)) == null) continue;
            diffs.add(diffDetail);
        }
        for (i = 0; i < expectedArray.size(); ++i) {
            if (mappedExpectedToActual.containsKey(i) || (diffDetail = this.getDiffDetail(diffKey + ", (.*), /", expectedArray.get(i), null, DiffType.MODIFY)) == null) continue;
            diffs.add(diffDetail);
        }
    }

    private void compute(ObjectNode expectedObject, ObjectNode actualObject, List<DiffDetail> diffs, String diffKey) {
        String[] expectedKeys = JsonTestCompareHandlerUtil.getObjectKeys(expectedObject);
        String[] actualKeys = JsonTestCompareHandlerUtil.getObjectKeys(actualObject);
        if (expectedKeys.length > 0) {
            for (String expectedKey : expectedKeys) {
                this.compute(expectedObject.get(expectedKey), actualObject.has(expectedKey) ? actualObject.get(expectedKey) : null, diffs, diffKey + ", " + expectedKey);
            }
        }
        if (actualKeys.length > 0) {
            for (String actualKey : actualKeys) {
                if (JsonTestCompareHandlerUtil.findStringInArray(actualKey, expectedKeys)) continue;
                this.compute(null, actualObject.get(actualKey), diffs, diffKey + ", " + actualKey);
            }
        }
    }

    private void compute(Object expected, Object actual, List<DiffDetail> diffs, String diffKey) {
        DiffDetail diffDetail;
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            DiffDetail diffDetail2 = this.getDiffDetail(diffKey + ", /", expected, actual, DiffType.MODIFY);
            if (diffDetail2 != null) {
                diffs.add(diffDetail2);
            }
            return;
        }
        if (expected instanceof ArrayNode && actual instanceof ArrayNode) {
            this.compute((ArrayNode)expected, (ArrayNode)actual, diffs, diffKey);
        } else if (expected instanceof ObjectNode && actual instanceof ObjectNode) {
            this.compute((ObjectNode)expected, (ObjectNode)actual, diffs, diffKey);
        } else if (!expected.equals(actual) && (diffDetail = this.getDiffDetail(diffKey + ", /", expected, actual, DiffType.MODIFY)) != null) {
            diffs.add(diffDetail);
        }
    }
}

