/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gojira.core;

import com.flipkart.gojira.core.Mode;
import com.flipkart.gojira.core.ProfileRepository;
import com.flipkart.gojira.core.ProfileState;
import com.flipkart.gojira.core.StartEndTestHandler;
import com.flipkart.gojira.core.injectors.GuiceInjector;
import com.flipkart.gojira.models.TestData;
import com.flipkart.gojira.models.TestDataType;
import com.flipkart.gojira.models.TestRequestData;
import com.flipkart.gojira.models.TestResponseData;
import com.flipkart.gojira.queuedsender.TestQueuedSender;
import com.flipkart.gojira.requestsampling.RequestSamplingRepository;
import com.flipkart.gojira.serde.SerdeHandlerRepository;
import com.flipkart.gojira.sinkstore.handlers.SinkHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformStartEndTestHandler<T extends TestDataType>
implements StartEndTestHandler<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransformStartEndTestHandler.class);
    private SerdeHandlerRepository serdeHandlerRepository = (SerdeHandlerRepository)GuiceInjector.getInjector().getInstance(SerdeHandlerRepository.class);
    private SinkHandler sinkHandler = (SinkHandler)GuiceInjector.getInjector().getInstance(SinkHandler.class);

    @Override
    public void start(String id, TestRequestData<T> requestData) {
        if (id == null || id.isEmpty()) {
            throw new RuntimeException("invalid test id.");
        }
        try {
            TestData testData = this.serdeHandlerRepository.getTestDataSerdeHandler().deserialize(this.sinkHandler.read(id), TestData.class);
            if (testData == null) {
                throw new RuntimeException("no data available against mentioned test id: " + id);
            }
            ProfileRepository.begin(id);
            ProfileRepository.setTestData(testData);
            ProfileRepository.setRequestData(requestData);
            ProfileRepository.setRequestMode(Mode.TRANSFORM);
            LOGGER.info("Profiling initiated for id: " + ProfileRepository.getTestData().getId());
        }
        catch (Exception e) {
            ProfileRepository.setProfileState(ProfileState.FAILED);
            LOGGER.warn("error starting test transform data. global_per_request_Id: " + id, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end(TestResponseData<T> responseData) {
        block6: {
            try {
                TestQueuedSender testQueuedSender = (TestQueuedSender)GuiceInjector.getInjector().getInstance(TestQueuedSender.class);
                if (!ProfileState.INITIATED.equals((Object)ProfileRepository.getProfileState()) || testQueuedSender == null) break block6;
                try {
                    LOGGER.info("Transform complete for id : " + ProfileRepository.getTestData().getId());
                    ProfileRepository.setResponseData(responseData);
                    TestData testData = ProfileRepository.getTestData();
                    if (testData != null) {
                        LOGGER.info("Transforming complete for id : " + ProfileRepository.getTestData().getId() + " sending to queuedSender.");
                        testQueuedSender.send(testData);
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("error writing test transformed data to datastore global_request_per_id: " + ProfileRepository.getGlobalPerRequestID(), (Throwable)e);
                }
            }
            finally {
                ProfileRepository.end();
            }
        }
    }

    private boolean fallsInSamplingBucket() {
        return (double)(System.nanoTime() % 10000L) < ((RequestSamplingRepository)GuiceInjector.getInjector().getInstance(RequestSamplingRepository.class)).getSamplingPercentage() * 100.0;
    }
}

