/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gojira.external.kafka;

import com.flipkart.gojira.core.injectors.TestExecutionInjector;
import com.flipkart.gojira.external.kafka.IKafkaHelper;
import com.flipkart.gojira.external.kafka.IKafkaManager;
import com.flipkart.gojira.external.kafka.KafkaProducerException;
import java.util.Arrays;
import java.util.concurrent.Future;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaHelper
implements IKafkaHelper {
    public static final Logger LOGGER = LoggerFactory.getLogger(KafkaHelper.class);

    @Override
    public RecordMetadata produce(String client, ProducerRecord<byte[], byte[]> producerRecord) throws KafkaProducerException {
        Producer<byte[], byte[]> producer = ((IKafkaManager)TestExecutionInjector.getInjector().getInstance(IKafkaManager.class)).getProducer(client);
        try {
            Future recordMetadataFuture = producer.send(producerRecord);
            LOGGER.trace("Producing record. " + Arrays.toString((byte[])producerRecord.key()));
            return (RecordMetadata)recordMetadataFuture.get();
        }
        catch (Exception e) {
            LOGGER.error("Record not produced: " + e.getMessage());
            throw new KafkaProducerException("Record not produced.", e);
        }
    }
}

