/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gojira.external.rmq;

import com.flipkart.gojira.core.injectors.TestExecutionInjector;
import com.flipkart.gojira.external.ExternalConfigRepository;
import com.flipkart.gojira.external.Managed;
import com.flipkart.gojira.external.SetupException;
import com.flipkart.gojira.external.ShutdownException;
import com.flipkart.gojira.external.config.ExternalConfig;
import com.flipkart.gojira.external.config.RmqConfig;
import com.flipkart.gojira.external.rmq.IRmqManager;
import com.flipkart.gojira.models.rmq.RmqTestDataType;
import com.rabbitmq.client.Address;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum RmqManager implements IRmqManager,
Managed
{
    RMQ_MANAGER;

    private static final Logger LOGGER;

    @Override
    public void setup() throws SetupException {
        try {
            Map<String, ExternalConfig> externalConfigMap = ((ExternalConfigRepository)TestExecutionInjector.getInjector().getInstance(ExternalConfigRepository.class)).getExternalConfigByType(RmqTestDataType.class);
            if (!externalConfigMap.isEmpty()) {
                for (Map.Entry<String, ExternalConfig> entry : externalConfigMap.entrySet()) {
                    ExternalConfig externalConfig = entry.getValue();
                    if (externalConfig == null) continue;
                    RmqConfig rmqConfig = (RmqConfig)externalConfig;
                    clientVsChannelMap.put(entry.getKey(), this.createChannel(rmqConfig));
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("error setting up rmq connections.", (Throwable)e);
            throw new SetupException("error setting up rmq connections.", e);
        }
    }

    @Override
    public void shutdown() throws ShutdownException {
        try {
            for (Map.Entry entry : clientVsChannelMap.entrySet()) {
                this.stopConsumer((Channel)entry.getValue());
            }
        }
        catch (Exception e) {
            LOGGER.error("error closing http connections.", (Throwable)e);
            throw new ShutdownException("error closing http connections.", e);
        }
    }

    private Channel createChannel(RmqConfig rmqConfig) throws SetupException {
        ConnectionFactory factory = new ConnectionFactory();
        factory.setUsername(rmqConfig.getUsername());
        factory.setPassword(rmqConfig.getPassword());
        factory.setVirtualHost(rmqConfig.getVirtualHost());
        factory.setAutomaticRecoveryEnabled(rmqConfig.isAutomaticRecoveryEnabled());
        LinkedList<Address> addressList = new LinkedList<Address>();
        for (String endpoint : rmqConfig.getEndpoints()) {
            addressList.add(new Address(endpoint, rmqConfig.getPort()));
            LOGGER.info("Adding the RMQ endpoint [" + endpoint + ":" + rmqConfig.getPort() + "] in connection factory");
        }
        Address[] addrArr = addressList.toArray(new Address[0]);
        LOGGER.info("Number of nodes connected to in RMQ:" + addrArr.length);
        try {
            Connection connection = factory.newConnection(addrArr);
            Channel rmqChannel = connection.createChannel();
            LOGGER.info("Connection to RMQ established.." + rmqChannel.getConnection().getAddress().getHostName());
            return rmqChannel;
        }
        catch (IOException | TimeoutException e) {
            String errorMsg = "Connection to RMQ could not be established..";
            LOGGER.error(errorMsg);
            throw new SetupException(errorMsg);
        }
    }

    private void stopConsumer(Channel channel) {
        try {
            LOGGER.info("Stopping Consumer Service");
            if (channel.getConnection().isOpen()) {
                LOGGER.info("closing RabbitMQ channel...");
                channel.getConnection().close();
            }
            if (channel.isOpen()) {
                channel.close();
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception while closing channel", (Throwable)e);
        }
    }

    @Override
    public Channel getChannelByClient(String client) {
        return (Channel)clientVsChannelMap.get(client);
    }

    static {
        LOGGER = LoggerFactory.getLogger(RmqManager.class);
    }
}

