/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gojira.serde.handlers.json.custom;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class Serializers {

    public static class TestMapSerializer
    extends JsonSerializer<Map> {
        public void serialize(Map value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            String mapType = value.getClass().getName();
            gen.writeStartArray();
            gen.writeStartObject();
            gen.writeStringField("TestMapSerializer|mapType", mapType);
            gen.writeEndObject();
            if (!value.isEmpty()) {
                int size = value.size();
                for (int i = 0; i < size; ++i) {
                    gen.writeStartObject();
                    if (value.keySet().toArray()[i] == null) {
                        gen.writeStringField("TestMapSerializer|mapElementKeyType", "NULL_ENTRY");
                    } else {
                        gen.writeStringField("TestMapSerializer|mapElementKeyType", value.keySet().toArray()[i].getClass().getName());
                    }
                    gen.writeEndObject();
                    gen.writeStartObject();
                    if (value.get(value.keySet().toArray()[i]) == null) {
                        gen.writeStringField("TestMapSerializer|mapElementValueType", "NULL_ENTRY");
                    } else {
                        gen.writeStringField("TestMapSerializer|mapElementValueType", value.get(value.keySet().toArray()[i]).getClass().getName());
                    }
                    gen.writeEndObject();
                    gen.writeStartObject();
                    gen.writeObjectField("mapElementKey", value.keySet().toArray()[i]);
                    gen.writeObjectField("mapElementValue", value.get(value.keySet().toArray()[i]));
                    gen.writeEndObject();
                }
            }
            gen.writeEndArray();
        }
    }

    public static class TestListSerializer
    extends JsonSerializer<List> {
        public void serialize(List value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            String listType = value.getClass().getName();
            gen.writeStartArray();
            gen.writeString(listType);
            if (!value.isEmpty()) {
                for (Object element : value) {
                    if (element == null) {
                        gen.writeObject((Object)"NULL_ENTRY");
                    } else {
                        gen.writeObject((Object)element.getClass().getName());
                    }
                    gen.writeObject(element);
                }
            }
            gen.writeEndArray();
        }
    }
}

