/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gojira.core;

import com.flipkart.gojira.core.Mode;
import com.flipkart.gojira.core.NoneStartEndTestHandler;
import com.flipkart.gojira.core.ProfileRepository;
import com.flipkart.gojira.core.ProfileStartEndTestHandler;
import com.flipkart.gojira.core.SerializeStartEndTestHandler;
import com.flipkart.gojira.core.StartEndTestHandler;
import com.flipkart.gojira.core.TestStartEndTestHandler;
import com.flipkart.gojira.core.TransformStartEndTestHandler;
import com.flipkart.gojira.models.TestDataType;
import com.flipkart.gojira.models.TestRequestData;
import com.flipkart.gojira.models.TestResponseData;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProfileOrTestHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultProfileOrTestHandler.class);
    private static final Map<Mode, StartEndTestHandler> startTestHandlerHashMap = Collections.unmodifiableMap(new HashMap<Mode, StartEndTestHandler>(){
        {
            this.put(Mode.PROFILE, new ProfileStartEndTestHandler());
            this.put(Mode.TEST, new TestStartEndTestHandler());
            this.put(Mode.NONE, new NoneStartEndTestHandler());
            this.put(Mode.SERIALIZE, new SerializeStartEndTestHandler());
            this.put(Mode.TRANSFORM, new TransformStartEndTestHandler());
        }
    });

    public static void start(String id, TestRequestData<? extends TestDataType> requestData, Mode requestMode) {
        if (startTestHandlerHashMap.containsKey((Object)requestMode)) {
            startTestHandlerHashMap.get((Object)requestMode).start(id, requestData);
            return;
        }
        LOGGER.error("Processing logic not implemented for this mode: " + (Object)((Object)requestMode));
    }

    public static void end(TestResponseData<? extends TestDataType> responseData) {
        if (startTestHandlerHashMap.containsKey((Object)ProfileRepository.getRequestMode())) {
            startTestHandlerHashMap.get((Object)ProfileRepository.getRequestMode()).end(responseData);
            return;
        }
        LOGGER.error("Processing logic not implemented for this mode: " + (Object)((Object)ProfileRepository.getRequestMode()));
    }
}

