/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gojira.core;

import com.flipkart.gojira.core.HttpFilterHandler;
import com.flipkart.gojira.core.Mode;
import com.flipkart.gojira.core.NoneHttpFilterHandler;
import com.flipkart.gojira.core.ProfileHttpFilterHandler;
import com.flipkart.gojira.core.ProfileRepository;
import com.flipkart.gojira.core.SerializeHttpFilterHandler;
import com.flipkart.gojira.core.TestHttpFilterHandler;
import com.flipkart.gojira.core.TransformHttpFilterHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ReadListener;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpFilter.class);
    private static final Map<Mode, HttpFilterHandler> FILTER_HANDLER_MAP = Collections.unmodifiableMap(new HashMap<Mode, HttpFilterHandler>(){
        {
            this.put(Mode.NONE, new NoneHttpFilterHandler());
            this.put(Mode.PROFILE, new ProfileHttpFilterHandler());
            this.put(Mode.TEST, new TestHttpFilterHandler());
            this.put(Mode.SERIALIZE, new SerializeHttpFilterHandler());
            this.put(Mode.TRANSFORM, new TransformHttpFilterHandler());
        }
    });

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        CustomHttpServletRequestWrapper requestWrapper = new CustomHttpServletRequestWrapper((HttpServletRequest)request);
        Mode requestMode = ProfileRepository.ModeHelper.getRequestMode(requestWrapper.getHeader("X-GOJIRA-MODE"));
        if (FILTER_HANDLER_MAP.containsKey((Object)requestMode)) {
            if (FILTER_HANDLER_MAP.get((Object)requestMode).preFilter(requestWrapper)) {
                TestServletResponseWrapper testServletResponseWrapper = new TestServletResponseWrapper((HttpServletResponse)response);
                try {
                    FILTER_HANDLER_MAP.get((Object)ProfileRepository.getRequestMode()).filter(requestWrapper, testServletResponseWrapper, chain);
                }
                finally {
                    FILTER_HANDLER_MAP.get((Object)ProfileRepository.getRequestMode()).postFilter(requestWrapper, testServletResponseWrapper, response);
                }
            }
        } else {
            LOGGER.error("Processing logic not implemented for this mode: " + (Object)((Object)requestMode));
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }

    public class CustomHttpServletRequestWrapper
    extends HttpServletRequestWrapper {
        private final byte[] body;

        public CustomHttpServletRequestWrapper(HttpServletRequest request) {
            super(request);
            try {
                this.body = IOUtils.toByteArray((InputStream)super.getInputStream());
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to read the stream", ex);
            }
        }

        public ServletInputStream getInputStream() throws IOException {
            final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.body);
            ServletInputStream inputStream = new ServletInputStream(){

                public int read() throws IOException {
                    return byteArrayInputStream.read();
                }

                public int available() throws IOException {
                    return byteArrayInputStream.available();
                }

                public boolean isFinished() {
                    return true;
                }

                public boolean isReady() {
                    return true;
                }

                public void setReadListener(ReadListener readListener) {
                }
            };
            return inputStream;
        }
    }

    private class TestBufferedServletOutputStream
    extends ServletOutputStream {
        private ByteArrayOutputStream bos = new ByteArrayOutputStream();

        private TestBufferedServletOutputStream() {
        }

        public void write(int data) {
            this.bos.write(data);
        }

        public boolean isReady() {
            return true;
        }

        public void setWriteListener(WriteListener writeListener) {
        }

        public byte[] getBuffer() {
            return this.bos.toByteArray();
        }
    }

    public class TestServletResponseWrapper
    extends HttpServletResponseWrapper {
        private TestBufferedServletOutputStream bufferedServletOut;
        private ServletOutputStream outputStream;

        public TestServletResponseWrapper(HttpServletResponse servletResponse) {
            super(servletResponse);
            this.bufferedServletOut = new TestBufferedServletOutputStream();
            this.outputStream = null;
        }

        public void sendError(int sc, String msg) throws IOException {
        }

        public void sendError(int sc) throws IOException {
        }

        public ServletOutputStream getOutputStream() throws IOException {
            if (this.outputStream == null) {
                this.outputStream = this.bufferedServletOut;
            }
            return this.outputStream;
        }

        public void flushBuffer() throws IOException {
            if (this.outputStream != null) {
                this.outputStream.flush();
            }
        }

        public byte[] getBuffer() {
            return this.bufferedServletOut.getBuffer();
        }
    }
}

