/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gojira.core;

import com.flipkart.gojira.core.DefaultProfileOrTestHandler;
import com.flipkart.gojira.core.Mode;
import com.flipkart.gojira.core.NoneRmqFilterHandler;
import com.flipkart.gojira.core.ProfileRepository;
import com.flipkart.gojira.core.ProfileRmqFilterHandler;
import com.flipkart.gojira.core.RmqFilterHandler;
import com.flipkart.gojira.core.SerializeRmqFilterHandler;
import com.flipkart.gojira.core.TestRmqFilterHandler;
import com.flipkart.gojira.models.rmq.RmqTestResponseData;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.LongString;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RmqFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RmqFilter.class);
    private static final Map<Mode, RmqFilterHandler> FILTER_HANDLER_MAP = Collections.unmodifiableMap(new HashMap<Mode, RmqFilterHandler>(){
        {
            this.put(Mode.NONE, new NoneRmqFilterHandler());
            this.put(Mode.PROFILE, new ProfileRmqFilterHandler());
            this.put(Mode.TEST, new TestRmqFilterHandler());
            this.put(Mode.SERIALIZE, new SerializeRmqFilterHandler());
        }
    });

    public void start(String exchangeName, byte[] routingKey, byte[] data, AMQP.BasicProperties basicProperties, boolean mandatory) {
        Mode requestMode = ProfileRepository.ModeHelper.getRequestMode(this.getModeHeader(basicProperties));
        FILTER_HANDLER_MAP.getOrDefault((Object)requestMode, new NoneRmqFilterHandler()).handle(exchangeName, routingKey, data, basicProperties, mandatory);
    }

    public void end(byte[] bytes) {
        RmqTestResponseData rmqTestResponseData = RmqTestResponseData.builder().setRespondData(bytes).build();
        DefaultProfileOrTestHandler.end(rmqTestResponseData);
    }

    private String getModeHeader(AMQP.BasicProperties basicProperties) {
        if (basicProperties == null || basicProperties.getHeaders() == null || basicProperties.getHeaders().isEmpty()) {
            LOGGER.error("Headers not present for RMQ");
            return null;
        }
        Map headersMap = basicProperties.getHeaders();
        try {
            for (Map.Entry header : headersMap.entrySet()) {
                if (!"X-GOJIRA-MODE".equals(header.getKey()) || !(header.getValue() instanceof LongString)) continue;
                byte[] correlationIdAsByteArray = ((LongString)header.getValue()).getBytes();
                return new String(correlationIdAsByteArray, "UTF-8");
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to encode mode headers", (Throwable)e);
        }
        return null;
    }
}

