/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gojira.core;

import com.flipkart.compare.TestCompareException;
import com.flipkart.gojira.compare.GojiraCompareHandlerRepository;
import com.flipkart.gojira.core.MethodDataInterceptorHandler;
import com.flipkart.gojira.core.ProfileRepository;
import com.flipkart.gojira.core.ProfileState;
import com.flipkart.gojira.core.annotations.ProfileOrTest;
import com.flipkart.gojira.core.injectors.GuiceInjector;
import com.flipkart.gojira.execute.TestExecutionException;
import com.flipkart.gojira.execute.TranssformExecutionException;
import com.flipkart.gojira.hash.HashHandlerUtil;
import com.flipkart.gojira.hash.TestHashHandler;
import com.flipkart.gojira.models.MethodData;
import com.flipkart.gojira.models.MethodDataType;
import com.flipkart.gojira.serde.SerdeHandlerRepository;
import com.google.common.base.Strings;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformMethodDataInterceptorHandler
implements MethodDataInterceptorHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransformMethodDataInterceptorHandler.class);
    private GojiraCompareHandlerRepository gojiraCompareHandlerRepository = (GojiraCompareHandlerRepository)((Object)GuiceInjector.getInjector().getInstance(GojiraCompareHandlerRepository.class));
    private SerdeHandlerRepository serdeHandlerRepository = (SerdeHandlerRepository)GuiceInjector.getInjector().getInstance(SerdeHandlerRepository.class);

    @Override
    public Object handle(MethodInvocation invocation) throws Throwable {
        if (!ProfileRepository.getProfileState().equals((Object)ProfileState.INITIATED)) {
            throw new TestExecutionException("Transform was not initiated.");
        }
        String genericMethodName = null;
        String globalPerRequestId = null;
        try {
            globalPerRequestId = ProfileRepository.getGlobalPerRequestID();
        }
        catch (Exception e) {
            LOGGER.error("error getting globalPerRequestId.", (Throwable)e);
            throw new TestExecutionException("error getting globalPerRequestId.", e);
        }
        try {
            genericMethodName = invocation.getMethod().toGenericString();
        }
        catch (Exception e) {
            LOGGER.error("error getting methodGenericString. globalPerRequestId: " + globalPerRequestId, (Throwable)e);
            throw new TestExecutionException("error getting methodGenericString. globalPerRequestId: " + globalPerRequestId, e);
        }
        if (ProfileRepository.getTestData() == null) {
            LOGGER.error("test data null. method: " + genericMethodName + " globalPerRequestId: " + globalPerRequestId);
            throw new TestExecutionException("test data null. method: " + genericMethodName + " globalPerRequestId: " + globalPerRequestId);
        }
        if (ProfileRepository.getTestData().getMethodDataMap() == null) {
            LOGGER.error("test data method data map null. method: " + genericMethodName + " globalPerRequestId: " + globalPerRequestId);
            throw new TestExecutionException("test data method data map null. method: " + genericMethodName + " globalPerRequestId: " + globalPerRequestId);
        }
        if (ProfileRepository.getTestData().getMethodDataMap().get(genericMethodName) == null) {
            LOGGER.error("test data method data map for method null. method: " + genericMethodName + " globalPerRequestId: " + globalPerRequestId);
            throw new TestExecutionException("test data method data map  for method null. method: " + genericMethodName + " globalPerRequestId: " + globalPerRequestId);
        }
        ConcurrentSkipListMap<Long, ConcurrentHashMap<MethodDataType, List<MethodData>>> perMethodAllEntries = ProfileRepository.getTestData().getMethodDataMap().get(genericMethodName);
        ConcurrentHashMap<MethodDataType, List<MethodData>> methodDataMap = null;
        for (Map.Entry<Long, ConcurrentHashMap<MethodDataType, List<MethodData>>> entry : perMethodAllEntries.entrySet()) {
            Long perMethodEntryKey = entry.getKey();
            ConcurrentHashMap<MethodDataType, List<MethodData>> perMethodEntryValue = entry.getValue();
            if (perMethodEntryValue == null || perMethodEntryValue.isEmpty()) {
                LOGGER.error("methodDataMap null or empty, error running transform. method: " + genericMethodName + " globalPerRequestId: " + globalPerRequestId);
                throw new TestExecutionException("methodDataMap null or empty, error running transform. method: " + genericMethodName + " globalPerRequestId: " + globalPerRequestId);
            }
            if (!(perMethodEntryValue.containsKey((Object)MethodDataType.EXCEPTION) && !perMethodEntryValue.get((Object)MethodDataType.EXCEPTION).isEmpty() || perMethodEntryValue.containsKey((Object)MethodDataType.RETURN) && !perMethodEntryValue.get((Object)MethodDataType.RETURN).isEmpty())) {
                LOGGER.error("both return and exception data not present in methodDataMap, error running transform. method: " + genericMethodName + " globalPerRequestId: " + globalPerRequestId);
                throw new TestExecutionException("both return and exception data not present in methodDataMap, error running transform. method: " + genericMethodName + " globalPerRequestId: " + globalPerRequestId);
            }
            try {
                for (MethodData methodData : perMethodEntryValue.get((Object)MethodDataType.ARGUMENT_BEFORE)) {
                    if (methodData == null) {
                        LOGGER.error("methodData before argument null, error running transform. method: " + genericMethodName + " globalPerRequestId: " + globalPerRequestId);
                        throw new TestExecutionException("methodData before argument null, error running transform. method: " + genericMethodName + " globalPerRequestId: " + globalPerRequestId);
                    }
                    if (methodData.getData() == null && invocation.getArguments()[methodData.getPosition()] == null || methodData.getData() != null && invocation.getArguments()[methodData.getPosition()] != null) continue;
                    LOGGER.error("error comparing during transform: method: " + genericMethodName + " globalPerRequestId: " + globalPerRequestId);
                    throw new TestCompareException("error comparing during transform: method: " + genericMethodName + " globalPerRequestId: " + globalPerRequestId);
                }
                methodDataMap = perMethodEntryValue;
                ConcurrentHashMap<MethodDataType, List<MethodData>> concurrentCheckValue = perMethodAllEntries.remove(perMethodEntryKey);
                if (concurrentCheckValue != null) break;
            }
            catch (TestCompareException e) {
                LOGGER.warn("recorded method argument list does not match with current method arguments. trying with another set of recorded argument against the method. method: " + genericMethodName + " globalPerRequestId: " + globalPerRequestId);
            }
        }
        if (methodDataMap == null) {
            LOGGER.error("unable to find any matching argument(s) from the queue of arguments against method signature: " + genericMethodName + ". this could mean not ignored diffs in the comparison that is done for arguments before method execution. method: " + genericMethodName + " globalPerRequestId: " + globalPerRequestId);
            throw new TestCompareException("unable to find any matching argument(s) from the queue of arguments against method signature: " + genericMethodName + ". this could mean not ignored diffs in the comparison that is done for arguments before method execution. method: " + genericMethodName + " globalPerRequestId: " + globalPerRequestId);
        }
        if (methodDataMap.containsKey((Object)MethodDataType.ARGUMENT_AFTER) && !((List)methodDataMap.get((Object)MethodDataType.ARGUMENT_AFTER)).isEmpty()) {
            int index = -1;
            for (MethodData methodData : (List)methodDataMap.get((Object)MethodDataType.ARGUMENT_AFTER)) {
                if (methodData == null || methodData.getData() != null && methodData.getClassName() == null) {
                    LOGGER.error("argument " + index + " methodData or methodData.getData not null and methodData.className null, error running test.method: " + genericMethodName + " globalPerRequestId: " + globalPerRequestId);
                    throw new TranssformExecutionException("argument " + index + " methodData or methodData.getData not null and methodData.className null, error running test.method: " + genericMethodName + " globalPerRequestId: " + globalPerRequestId);
                }
                ++index;
                if (methodData.getData() == null) {
                    invocation.getArguments()[index] = null;
                    continue;
                }
                this.serdeHandlerRepository.getOrUpdateAndGetOrDefaultMethodArgumentDataSerdeHandler(invocation, methodData.getPosition()).deserializeToInstance(methodData.getData(), invocation.getArguments()[index]);
            }
        }
        if (methodDataMap.containsKey((Object)MethodDataType.EXCEPTION) && !((List)methodDataMap.get((Object)MethodDataType.EXCEPTION)).isEmpty()) {
            if (((List)methodDataMap.get((Object)MethodDataType.EXCEPTION)).get(0) == null || ((MethodData)((List)methodDataMap.get((Object)MethodDataType.EXCEPTION)).get(0)).getClassName() == null || ((MethodData)((List)methodDataMap.get((Object)MethodDataType.EXCEPTION)).get(0)).getData() == null) {
                LOGGER.error("exception methodData or methodData.className or methodData.data null, error running test.method: " + genericMethodName + " globalPerRequestId: " + globalPerRequestId);
                throw new TestExecutionException("exception methodData or methodData.className or methodData.data null, error running test.method: " + genericMethodName + " globalPerRequestId: " + globalPerRequestId);
            }
            LOGGER.info("Throwing exception that was captured while profiling.");
            throw (Throwable)this.serdeHandlerRepository.getExceptionDataSerdeHandler(genericMethodName, methodDataMap.get((Object)MethodDataType.EXCEPTION).get(0).getClassName()).deserialize(methodDataMap.get((Object)MethodDataType.EXCEPTION).get(0).getData(), Class.forName(methodDataMap.get((Object)MethodDataType.EXCEPTION).get(0).getClassName()));
        }
        if (methodDataMap.containsKey((Object)MethodDataType.RETURN) && !((List)methodDataMap.get((Object)MethodDataType.RETURN)).isEmpty()) {
            if (((List)methodDataMap.get((Object)MethodDataType.RETURN)).get(0) == null || ((MethodData)((List)methodDataMap.get((Object)MethodDataType.RETURN)).get(0)).getData() != null && methodDataMap.get((Object)MethodDataType.RETURN).get(0).getClassName() == null) {
                LOGGER.error("return methodData or methodData.getData not null and methodData.className null, error running test.method: " + genericMethodName + " globalPerRequestId: " + globalPerRequestId);
                throw new TestExecutionException("return methodData or methodData.getData not null and methodData.className null, error running test.method: " + genericMethodName + " globalPerRequestId: " + globalPerRequestId);
            }
            Object originalObject = methodDataMap.get((Object)MethodDataType.RETURN).get(0).getData() == null ? null : this.serdeHandlerRepository.getOrUpdateAndGetOrDefaultReturnDataSerdeHandler(invocation).deserialize(methodDataMap.get((Object)MethodDataType.RETURN).get(0).getData(), Class.forName(methodDataMap.get((Object)MethodDataType.RETURN).get(0).getClassName()));
            ArrayList<MethodData> arrayList = new ArrayList<MethodData>();
            Object transformedObject = null;
            Exception invocationException = null;
            ProfileOrTest annotation = invocation.getMethod().getAnnotation(ProfileOrTest.class);
            Method transformedMethod = null;
            if (!Strings.isNullOrEmpty((String)annotation.transformMethod())) {
                try {
                    transformedMethod = invocation.getMethod().getDeclaringClass().getDeclaredMethod(annotation.transformMethod(), invocation.getMethod().getReturnType(), String.class, invocation.getArguments().getClass());
                }
                catch (Exception e) {
                    throw new TranssformExecutionException("not able to find transformed method,error running transform.method: " + genericMethodName + " globalPerRequestId: " + globalPerRequestId);
                }
                try {
                    transformedObject = transformedMethod.invoke(invocation.getMethod().getDeclaringClass().newInstance(), originalObject, invocation.getArguments());
                }
                catch (Exception e) {
                    invocationException = e;
                }
                int index = -1;
                try {
                    ArrayList<MethodData> argumenAfterList = new ArrayList<MethodData>();
                    for (Object arg : invocation.getArguments()) {
                        TestHashHandler hashHandler = HashHandlerUtil.getHashHandler(invocation, ++index);
                        MethodData methodData = new MethodData(MethodDataType.ARGUMENT_AFTER, arg == null ? null : arg.getClass().getName(), arg == null ? null : (hashHandler == null ? this.serdeHandlerRepository.getOrUpdateAndGetOrDefaultMethodArgumentDataSerdeHandler(invocation, index).serialize(arg) : hashHandler.hash(this.serdeHandlerRepository.getOrUpdateAndGetOrDefaultMethodArgumentDataSerdeHandler(invocation, index).serialize(arg))), index);
                        argumenAfterList.add(methodData);
                    }
                    methodDataMap.put(MethodDataType.ARGUMENT_AFTER, argumenAfterList);
                }
                catch (Exception e) {
                    LOGGER.warn("error transforming argument data before method execution, method: " + genericMethodName + " argument index: " + index + " globalPerRequestId: " + globalPerRequestId, (Throwable)e);
                    ProfileRepository.setProfileState(ProfileState.FAILED);
                }
                if (invocationException == null) {
                    arrayList.add(new MethodData(MethodDataType.RETURN, transformedObject == null ? null : transformedObject.getClass().getName(), transformedObject == null ? null : this.serdeHandlerRepository.getOrUpdateAndGetOrDefaultReturnDataSerdeHandler(invocation).serialize(transformedObject), 0));
                    methodDataMap.put(MethodDataType.RETURN, arrayList);
                } else {
                    arrayList.add(new MethodData(MethodDataType.EXCEPTION, invocationException.getClass().getName(), this.serdeHandlerRepository.getExceptionDataSerdeHandler(genericMethodName, invocationException.getClass().getName()).serialize(invocationException), 0));
                    methodDataMap.put(MethodDataType.EXCEPTION, arrayList);
                    methodDataMap.remove((Object)MethodDataType.RETURN);
                }
                try {
                    ProfileRepository.addInterceptedData(genericMethodName, methodDataMap);
                }
                catch (Exception e) {
                    LOGGER.error("error adding intercepted data against method : " + genericMethodName + " globalPerRequestId: " + globalPerRequestId);
                    ProfileRepository.setProfileState(ProfileState.FAILED);
                }
                if (invocationException != null) {
                    throw invocationException;
                }
                return transformedObject;
            }
            return originalObject;
        }
        LOGGER.info("returning null from TestMethodDataInterceptorHandler. No return data or exception was profiled.");
        return null;
    }
}

