/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gojira.external.http;

import com.flipkart.gojira.core.injectors.TestExecutionInjector;
import com.flipkart.gojira.external.ExternalConfigRepository;
import com.flipkart.gojira.external.config.ExternalConfig;
import com.flipkart.gojira.external.config.HttpConfig;
import com.flipkart.gojira.external.http.HttpCallException;
import com.flipkart.gojira.external.http.IHttpHelper;
import com.flipkart.gojira.external.http.IHttpManager;
import com.flipkart.gojira.models.http.HttpTestDataType;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.Response;
import org.asynchttpclient.util.HttpConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpHelper
implements IHttpHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpHelper.class);

    @Override
    public Response doGet(String clientId, String urlWithQueryParams, Map<String, String> header) throws HttpCallException {
        RequestBuilder requestBuilder = (RequestBuilder)new RequestBuilder().setMethod(HttpConstants.Methods.GET);
        for (Map.Entry<String, String> entry : header.entrySet()) {
            requestBuilder.addHeader((CharSequence)entry.getKey(), entry.getValue());
        }
        return this.execute(clientId, requestBuilder, urlWithQueryParams);
    }

    @Override
    public Response doPost(String clientId, String urlWithQueryParams, Map<String, String> header, byte[] payload) throws HttpCallException {
        RequestBuilder requestBuilder = (RequestBuilder)((RequestBuilder)new RequestBuilder().setMethod(HttpConstants.Methods.POST)).setBody(payload);
        for (Map.Entry<String, String> entry : header.entrySet()) {
            requestBuilder.addHeader((CharSequence)entry.getKey(), entry.getValue());
        }
        return this.execute(clientId, requestBuilder, urlWithQueryParams);
    }

    @Override
    public Response doPut(String clientId, String urlWithQueryParams, Map<String, String> header, byte[] payload) throws HttpCallException {
        RequestBuilder requestBuilder = (RequestBuilder)((RequestBuilder)new RequestBuilder().setMethod(HttpConstants.Methods.PUT)).setBody(payload);
        for (Map.Entry<String, String> entry : header.entrySet()) {
            requestBuilder.addHeader((CharSequence)entry.getKey(), entry.getValue());
        }
        return this.execute(clientId, requestBuilder, urlWithQueryParams);
    }

    @Override
    public Response doDelete(String clientId, String urlWithQueryParams, Map<String, String> header) throws HttpCallException {
        RequestBuilder requestBuilder = (RequestBuilder)new RequestBuilder().setMethod(HttpConstants.Methods.DELETE);
        for (Map.Entry<String, String> entry : header.entrySet()) {
            requestBuilder.addHeader((CharSequence)entry.getKey(), entry.getValue());
        }
        return this.execute(clientId, requestBuilder, urlWithQueryParams);
    }

    private Response execute(String clientId, RequestBuilder requestBuilder, String urlWithQueryParams) throws HttpCallException {
        DefaultAsyncHttpClient defaultAsyncHttpClient = ((IHttpManager)TestExecutionInjector.getInjector().getInstance(IHttpManager.class)).getClient(clientId);
        ExternalConfig clientConfig = ((ExternalConfigRepository)TestExecutionInjector.getInjector().getInstance(ExternalConfigRepository.class)).getExternalConfigFor(clientId, HttpTestDataType.class);
        HttpConfig httpConfig = (HttpConfig)clientConfig;
        String externalCallUrl = "http://" + httpConfig.getHostNamePort() + urlWithQueryParams;
        requestBuilder.setUrl(externalCallUrl);
        LOGGER.trace(String.format("making an external call to uri: %s with clientId: %s.", externalCallUrl, clientId));
        ListenableFuture responseListenableFuture = defaultAsyncHttpClient.executeRequest(requestBuilder);
        try {
            return (Response)responseListenableFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error("error executing http request: " + e.getMessage());
            throw new HttpCallException("error executing http request. ", e);
        }
    }
}

