/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gojira.serde.handlers.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.jsontype.SubtypeResolver;
import com.fasterxml.jackson.databind.jsontype.impl.StdSubtypeResolver;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.flipkart.gojira.serde.TestSerdeException;
import com.flipkart.gojira.serde.handlers.TestSerdeHandler;
import com.flipkart.gojira.serde.handlers.TypeParameter;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonDefaultTestSerdeHandler
implements TestSerdeHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonDefaultTestSerdeHandler.class);
    protected final ObjectMapper mapper = new ObjectMapper().enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT).enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING).enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).setSubtypeResolver((SubtypeResolver)new StdSubtypeResolver());
    private final SimpleModule simpleModule = new SimpleModule();

    public <T> JsonDefaultTestSerdeHandler registerSerializer(Class<T> type, JsonSerializer<T> ser) {
        this.simpleModule.addSerializer(type, ser);
        this.mapper.registerModule((Module)this.simpleModule);
        return this;
    }

    public <T> JsonDefaultTestSerdeHandler registerDeSerializer(Class<T> type, JsonDeserializer<T> deSer) {
        this.simpleModule.addDeserializer(type, deSer);
        this.mapper.registerModule((Module)this.simpleModule);
        return this;
    }

    @Override
    public <T> byte[] serialize(T obj) throws TestSerdeException {
        try {
            return this.mapper.writeValueAsBytes(obj);
        }
        catch (JsonProcessingException e) {
            LOGGER.trace("error serializing data. class: " + obj.getClass(), (Throwable)e);
            throw new TestSerdeException("error serializing data. class: " + obj.getClass(), e);
        }
    }

    @Override
    public <T> T deserialize(byte[] bytes, Class<T> clazz) throws TestSerdeException {
        try {
            return (T)this.mapper.readValue(bytes, clazz);
        }
        catch (IOException e) {
            LOGGER.trace("error de-serializing data. class: " + clazz.toGenericString(), (Throwable)e);
            throw new TestSerdeException("error de-serializing data. class: " + clazz.toGenericString(), e);
        }
    }

    @Override
    public <T> T deserialize(byte[] bytes, TypeParameter<T> typeParameter) throws TestSerdeException {
        try {
            return (T)this.mapper.readValue(bytes, this.mapper.constructType(typeParameter.getType()));
        }
        catch (IOException e) {
            LOGGER.error("error de-serializing data. type: " + typeParameter, (Throwable)e);
            throw new TestSerdeException("error de-serializing data. type: " + typeParameter, e);
        }
    }

    @Override
    public <T> void deserializeToInstance(byte[] bytes, T obj) throws TestSerdeException {
        try {
            this.mapper.readerForUpdating(obj).readValue(bytes);
        }
        catch (IOException e) {
            LOGGER.trace("error updating object. class: " + obj.getClass(), (Throwable)e);
            throw new TestSerdeException("error updating object. class: " + obj.getClass(), e);
        }
    }
}

