/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gojira.serde.handlers.json.custom;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Deserializers {
    private static final Logger LOGGER = LoggerFactory.getLogger(Deserializers.class);

    public static class TestMapDeserializer
    extends JsonDeserializer<Map> {
        public Map deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            Map map;
            String mapType;
            ObjectCodec oc = p.getCodec();
            ArrayNode arrayNode = (ArrayNode)oc.readTree(p);
            String string = mapType = arrayNode.get(0) != null ? arrayNode.get(0).get("TestMapSerializer|mapType").asText() : null;
            if (mapType == null) {
                return new HashMap();
            }
            arrayNode.remove(0);
            try {
                map = (Map)Class.forName(mapType).newInstance();
            }
            catch (Exception e) {
                LOGGER.error("Error creating new map of type " + mapType + " in JsonMapListSerdeHandler. ", (Throwable)e);
                throw new IOException("Error creating new map of type " + mapType + " in JsonMapListSerdeHandler. ", e);
            }
            if (arrayNode.size() == 0) {
                return map;
            }
            try {
                Iterator elements = arrayNode.elements();
                String mapKeyType = null;
                String mapValueType = null;
                String type = null;
                boolean mapKey = true;
                boolean mapValue = false;
                while (elements.hasNext()) {
                    ObjectNode element = (ObjectNode)elements.next();
                    Iterator keys = element.fieldNames();
                    if (mapKey || mapValue) {
                        if (mapKey) {
                            mapKeyType = element.get("TestMapSerializer|mapElementKeyType").asText();
                            mapKey = false;
                            mapValue = true;
                            continue;
                        }
                        mapValueType = element.get("TestMapSerializer|mapElementValueType").asText();
                        mapValue = false;
                        continue;
                    }
                    ArrayList<Object> keyValuePair = new ArrayList<Object>();
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        if ("NULL_ENTRY".equals(type = type == null ? mapKeyType : mapValueType)) {
                            keyValuePair.add(null);
                            continue;
                        }
                        Object keyOrValue = Map.class.isAssignableFrom(Class.forName(type)) ? oc.treeToValue((TreeNode)element.get(key), Map.class) : (List.class.isAssignableFrom(Class.forName(type)) ? oc.treeToValue((TreeNode)element.get(key), List.class) : oc.treeToValue((TreeNode)element.get(key), Class.forName(type)));
                        keyValuePair.add(keyOrValue);
                    }
                    map.put(keyValuePair.get(0), keyValuePair.get(1));
                    keyValuePair.clear();
                    mapKey = true;
                    type = null;
                }
                return map;
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("class cast exception", (Throwable)e);
                throw new IOException("class cast exception", e);
            }
        }
    }

    public static class TestListDeserializer
    extends JsonDeserializer<List> {
        public List deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            List list;
            ObjectCodec oc = p.getCodec();
            JsonNode jsonNode = (JsonNode)oc.readTree(p);
            ArrayNode arrayNode = (ArrayNode)jsonNode;
            String listType = arrayNode.get(0).asText();
            try {
                list = (List)Class.forName(arrayNode.get(0).asText()).newInstance();
            }
            catch (Exception e) {
                LOGGER.error("Error creating new list of type " + listType + " in JsonMapListSerdeHandler. ", (Throwable)e);
                throw new IOException("Error creating new list of type " + listType + " in JsonMapListSerdeHandler. ", e);
            }
            if (arrayNode.get(1) == null) {
                return list;
            }
            arrayNode.remove(0);
            try {
                boolean itemType = true;
                String listItemType = null;
                for (int i = 0; i < arrayNode.size(); ++i) {
                    if (itemType) {
                        listItemType = arrayNode.get(i).asText();
                        itemType = false;
                        continue;
                    }
                    if ("NULL_ENTRY".equals(listItemType)) {
                        list.add(null);
                    } else {
                        list.add(List.class.isAssignableFrom(Class.forName(listItemType)) ? oc.treeToValue((TreeNode)arrayNode.get(i), List.class) : (Map.class.isAssignableFrom(Class.forName(listItemType)) ? oc.treeToValue((TreeNode)arrayNode.get(i), Map.class) : oc.treeToValue((TreeNode)arrayNode.get(i), Class.forName(listItemType))));
                    }
                    itemType = true;
                }
                return list;
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("ClassNotFoundException exception", (Throwable)e);
                throw new IOException("ClassNotFoundException exception", e);
            }
        }
    }
}

