/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gojira.core;

import com.flipkart.gojira.core.DefaultProfileOrTestHandler;
import com.flipkart.gojira.core.KafkaFilterHandler;
import com.flipkart.gojira.core.Mode;
import com.flipkart.gojira.core.NoneKafkaFilterHandler;
import com.flipkart.gojira.core.ProfileKafkaFilterHandler;
import com.flipkart.gojira.core.ProfileRepository;
import com.flipkart.gojira.core.SerializeKafkaFilterHandler;
import com.flipkart.gojira.core.TestKafkaFilterHandler;
import com.flipkart.gojira.models.kafka.KafkaTestResponseData;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.header.Headers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaFilter.class);
    private static final Map<Mode, KafkaFilterHandler> filterHashMap = Collections.unmodifiableMap(new HashMap<Mode, KafkaFilterHandler>(){
        {
            this.put(Mode.NONE, new NoneKafkaFilterHandler());
            this.put(Mode.PROFILE, new ProfileKafkaFilterHandler());
            this.put(Mode.TEST, new TestKafkaFilterHandler());
            this.put(Mode.SERIALIZE, new SerializeKafkaFilterHandler());
        }
    });

    private static Map<String, byte[]> getMapForRequestHeaders(Headers headers) {
        HashMap<String, byte[]> headersMap = new HashMap<String, byte[]>();
        if (headers == null) {
            return headersMap;
        }
        headers.forEach(header -> headersMap.put(header.key(), header.value()));
        return headersMap;
    }

    public void start(String topicName, byte[] key, byte[] value, Headers recordHeaders) {
        Map<String, byte[]> headersMap = KafkaFilter.getMapForRequestHeaders(recordHeaders);
        filterHashMap.getOrDefault((Object)ProfileRepository.getMode(), new NoneKafkaFilterHandler()).handle(topicName, key, value, headersMap);
    }

    public void end(byte[] bytes) {
        KafkaTestResponseData kafkaTestResponseData = KafkaTestResponseData.builder().setRespondData(bytes).build();
        DefaultProfileOrTestHandler.end(kafkaTestResponseData);
    }
}

