/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gojira.core;

import com.flipkart.gojira.core.DefaultProfileOrTestHandler;
import com.flipkart.gojira.core.Mode;
import com.flipkart.gojira.core.NoneRmqFilterHandler;
import com.flipkart.gojira.core.ProfileRepository;
import com.flipkart.gojira.core.ProfileRmqFilterHandler;
import com.flipkart.gojira.core.RmqFilterHandler;
import com.flipkart.gojira.core.SerializeRmqFilterHandler;
import com.flipkart.gojira.core.TestRmqFilterHandler;
import com.flipkart.gojira.models.rmq.RmqTestResponseData;
import com.rabbitmq.client.AMQP;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RmqFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RmqFilter.class);
    private static final Map<Mode, RmqFilterHandler> filterHashMap = Collections.unmodifiableMap(new HashMap<Mode, RmqFilterHandler>(){
        {
            this.put(Mode.NONE, new NoneRmqFilterHandler());
            this.put(Mode.PROFILE, new ProfileRmqFilterHandler());
            this.put(Mode.TEST, new TestRmqFilterHandler());
            this.put(Mode.SERIALIZE, new SerializeRmqFilterHandler());
        }
    });

    public void start(String exchangeName, byte[] routingKey, byte[] data, AMQP.BasicProperties basicProperties, boolean mandatory) {
        filterHashMap.getOrDefault((Object)ProfileRepository.getMode(), new NoneRmqFilterHandler()).handle(exchangeName, routingKey, data, basicProperties, mandatory);
    }

    public void end(byte[] bytes) {
        RmqTestResponseData rmqTestResponseData = RmqTestResponseData.builder().setRespondData(bytes).build();
        DefaultProfileOrTestHandler.end(rmqTestResponseData);
    }
}

