/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gojira.core;

import com.flipkart.gojira.core.DefaultProfileOrTestHandler;
import com.flipkart.gojira.core.HttpFilter;
import com.flipkart.gojira.core.HttpFilterHandler;
import com.flipkart.gojira.core.ProfileRepository;
import com.flipkart.gojira.core.ProfileState;
import com.flipkart.gojira.models.http.HttpTestResponseData;
import java.io.IOException;
import javax.servlet.ServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHttpFilterHandler
extends HttpFilterHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestHttpFilterHandler.class);

    @Override
    public boolean preFilter(HttpFilter.CustomHttpServletRequestWrapper request) {
        String id = super.getTestId(request);
        if (id == null) {
            LOGGER.error("X-GOJIRA-ID header not present but the service is running in TEST mode.");
            throw new RuntimeException("X-GOJIRA-ID header not present but the service is running in TEST mode.");
        }
        boolean whitelisted = this.isWhitelistedUrl(request.getRequestURI(), request.getMethod());
        if (whitelisted) {
            DefaultProfileOrTestHandler.start(id, null);
        }
        return whitelisted;
    }

    @Override
    protected void postFilter(HttpFilter.CustomHttpServletRequestWrapper request, HttpFilter.TestServletResponseWrapper respWrapper, ServletResponse response) throws IOException {
        byte[] outputBuffer = respWrapper.getBuffer();
        response.getOutputStream().write(outputBuffer);
        if (this.isWhitelistedUrl(request.getRequestURI(), request.getMethod())) {
            HttpTestResponseData responseData = null;
            try {
                responseData = HttpTestResponseData.builder().setHeaders(this.getHeaders(respWrapper)).setBody(outputBuffer).setStatusCode(respWrapper.getStatus()).build();
            }
            catch (Exception e) {
                try {
                    ProfileRepository.setProfileState(ProfileState.FAILED);
                    LOGGER.error("error creating HttpTestResponseData.", (Throwable)e);
                    throw new RuntimeException("error creating HttpTestResponseData.", e);
                }
                catch (Throwable throwable) {
                    DefaultProfileOrTestHandler.end(responseData);
                    throw throwable;
                }
            }
            DefaultProfileOrTestHandler.end(responseData);
        }
    }
}

