/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gojira.external;

import com.flipkart.gojira.external.ExternalConfigRepository;
import com.flipkart.gojira.external.config.ExternalConfig;
import com.flipkart.gojira.models.TestDataType;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalConfigRepositoryImpl
extends ExternalConfigRepository {
    private Logger logger = LoggerFactory.getLogger(ExternalConfigRepositoryImpl.class);

    @Override
    public void setExternalConfig(Map<String, Map<Class<? extends TestDataType>, ExternalConfig>> externalConfig) {
        for (Map.Entry<String, Map<Class<? extends TestDataType>, ExternalConfig>> entry : externalConfig.entrySet()) {
            externalConfigHashMap.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Map<String, ExternalConfig> getExternalConfigByType(Class<? extends TestDataType> testDataType) {
        HashMap<String, ExternalConfig> clientMap = new HashMap<String, ExternalConfig>();
        if (!externalConfigHashMap.isEmpty()) {
            for (Map.Entry entry : externalConfigHashMap.entrySet()) {
                ExternalConfig config;
                String clientId = (String)entry.getKey();
                Map externalConfigByType = (Map)entry.getValue();
                if (externalConfigByType == null || externalConfigByType.isEmpty() || (config = (ExternalConfig)externalConfigByType.get(testDataType)) == null) continue;
                clientMap.put(clientId, config);
            }
        }
        return clientMap;
    }

    @Override
    public ExternalConfig getExternalConfigFor(String clientId, Class<? extends TestDataType> testDataType) {
        Map testTypeExternalConfigMap = (Map)externalConfigHashMap.get(clientId);
        if (testTypeExternalConfigMap != null) {
            return (ExternalConfig)testTypeExternalConfigMap.get(testDataType);
        }
        this.logger.error("External Config not found client :{} and sourceType :{}", (Object)clientId, testDataType);
        return null;
    }

    @Override
    public Map<String, Map<Class<? extends TestDataType>, ExternalConfig>> getExternalConfig() {
        return externalConfigHashMap;
    }
}

