/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gojira.external;

import com.flipkart.gojira.core.GojiraConstants;
import com.flipkart.gojira.external.ExternalConfigRepository;
import com.flipkart.gojira.external.ExternalConfigRepositoryImpl;
import com.flipkart.gojira.external.config.ExternalConfig;
import com.flipkart.gojira.models.TestDataType;
import com.google.inject.AbstractModule;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExternalModule
extends AbstractModule {
    private final Map<String, List<ExternalConfig>> clientToListConfigMap;

    public ExternalModule(Map<String, List<ExternalConfig>> clientToListConfigMap) {
        this.clientToListConfigMap = clientToListConfigMap;
    }

    protected void configure() {
        ExternalConfigRepositoryImpl externalConfigRepository = new ExternalConfigRepositoryImpl();
        HashMap<String, Map<Class<? extends TestDataType>, ExternalConfig>> externalConfigMap = new HashMap<String, Map<Class<? extends TestDataType>, ExternalConfig>>();
        this.clientToListConfigMap.forEach((client, configList) -> {
            externalConfigMap.putIfAbsent((String)client, new HashMap());
            configList.forEach(config -> {
                if (((Map)externalConfigMap.get(client)).containsKey(GojiraConstants.TEST_DATA_TYPE_STRING_TO_CLASS.get(config.getType()))) {
                    throw new RuntimeException("Only one config per type is allowed. ");
                }
                ((Map)externalConfigMap.get(client)).put(GojiraConstants.TEST_DATA_TYPE_STRING_TO_CLASS.get(config.getType()), config);
            });
        });
        externalConfigRepository.setExternalConfig(externalConfigMap);
        this.bind(ExternalConfigRepository.class).toInstance((Object)externalConfigRepository);
    }
}

