/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gojira.external.rmq;

import com.flipkart.gojira.core.injectors.TestExecutionInjector;
import com.flipkart.gojira.external.rmq.IRmqHelper;
import com.flipkart.gojira.external.rmq.IRmqManager;
import com.flipkart.gojira.external.rmq.RmqPublishException;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RmqHelper
implements IRmqHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(RmqHelper.class);

    @Override
    public void publish(String clientId, String exchangeName, byte[] routingKey, byte[] data, AMQP.BasicProperties properties, boolean mandatory) throws RmqPublishException {
        Channel channel = ((IRmqManager)TestExecutionInjector.getInjector().getInstance(IRmqManager.class)).getChannelByClient(clientId);
        if (channel == null) {
            LOGGER.error("Unable to publish as cannot instantiate channel");
            throw new RmqPublishException("Unable to publish as cannot instantiate channel");
        }
        try {
            String routingParam = new String(routingKey);
            channel.basicPublish(exchangeName, routingParam, mandatory, properties, data);
        }
        catch (Exception e) {
            LOGGER.error("Unable to publish to RMq channel", (Throwable)e);
            throw new RmqPublishException("Unable to publish to RMq channel", e);
        }
    }
}

