/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gojira.core;

import com.flipkart.gojira.core.MethodDataInterceptorHandler;
import com.flipkart.gojira.core.ProfileOrTestMethodInterceptor;
import com.flipkart.gojira.core.ProfileRepository;
import com.flipkart.gojira.core.ProfileState;
import com.flipkart.gojira.core.injectors.GuiceInjector;
import com.flipkart.gojira.hash.HashHandlerUtil;
import com.flipkart.gojira.hash.TestHashHandler;
import com.flipkart.gojira.models.MethodData;
import com.flipkart.gojira.models.MethodDataType;
import com.flipkart.gojira.serde.SerdeHandlerRepository;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileMethodDataInterceptorHandler
implements MethodDataInterceptorHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProfileOrTestMethodInterceptor.class);
    private SerdeHandlerRepository serdeHandlerRepository = (SerdeHandlerRepository)GuiceInjector.getInjector().getInstance(SerdeHandlerRepository.class);

    @Override
    public Object handle(MethodInvocation invocation) throws Throwable {
        MethodData methodData;
        TestHashHandler hashHandler;
        try {
            if (!ProfileRepository.getProfileState().equals((Object)ProfileState.INITIATED)) {
                return invocation.proceed();
            }
        }
        catch (Exception e) {
            LOGGER.error("Error getting profile state in ProfileMethodDataInterceptorHandler. ", (Throwable)e);
            ProfileRepository.setProfileState(ProfileState.FAILED);
            return invocation.proceed();
        }
        String methodGenericString = null;
        String globalPerRequestId = null;
        try {
            globalPerRequestId = ProfileRepository.getGlobalPerRequestID();
        }
        catch (Exception e) {
            LOGGER.error("error getting globalPerRequestId.", (Throwable)e);
            ProfileRepository.setProfileState(ProfileState.FAILED);
            return invocation.proceed();
        }
        try {
            methodGenericString = invocation.getMethod().toGenericString();
        }
        catch (Exception e) {
            LOGGER.error("error getting methodGenericString. globalPerRequestId: " + globalPerRequestId, (Throwable)e);
            ProfileRepository.setProfileState(ProfileState.FAILED);
            return invocation.proceed();
        }
        Object invocationReturnData = null;
        Exception invocationException = null;
        ConcurrentHashMap<MethodDataType, List<MethodData>> methodDataMap = new ConcurrentHashMap<MethodDataType, List<MethodData>>();
        int index = -1;
        try {
            ArrayList<MethodData> argumentBeforeList = new ArrayList<MethodData>();
            for (Object arg : invocation.getArguments()) {
                hashHandler = HashHandlerUtil.getHashHandler(invocation, ++index);
                methodData = new MethodData(MethodDataType.ARGUMENT_BEFORE, arg == null ? null : arg.getClass().getName(), arg == null ? null : (hashHandler == null ? this.serdeHandlerRepository.getOrUpdateAndGetOrDefaultMethodArgumentDataSerdeHandler(invocation, index).serialize(arg) : hashHandler.hash(this.serdeHandlerRepository.getOrUpdateAndGetOrDefaultMethodArgumentDataSerdeHandler(invocation, index).serialize(arg))), index);
                argumentBeforeList.add(methodData);
            }
            methodDataMap.put(MethodDataType.ARGUMENT_BEFORE, argumentBeforeList);
        }
        catch (Exception e) {
            LOGGER.warn("error profiling argument data before method execution, method: " + methodGenericString + " argument index: " + index + " globalPerRequestId: " + globalPerRequestId, (Throwable)e);
            ProfileRepository.setProfileState(ProfileState.FAILED);
            return invocation.proceed();
        }
        try {
            invocationReturnData = invocation.proceed();
        }
        catch (Exception e) {
            invocationException = e;
        }
        try {
            index = -1;
            try {
                ArrayList<MethodData> argumentAfterList = new ArrayList<MethodData>();
                for (Object arg : invocation.getArguments()) {
                    hashHandler = HashHandlerUtil.getHashHandler(invocation, ++index);
                    methodData = new MethodData(MethodDataType.ARGUMENT_AFTER, arg == null ? null : arg.getClass().getName(), arg == null ? null : (hashHandler == null ? this.serdeHandlerRepository.getOrUpdateAndGetOrDefaultMethodArgumentDataSerdeHandler(invocation, index).serialize(arg) : hashHandler.hash(this.serdeHandlerRepository.getOrUpdateAndGetOrDefaultMethodArgumentDataSerdeHandler(invocation, index).serialize(arg))), index);
                    argumentAfterList.add(methodData);
                }
                methodDataMap.put(MethodDataType.ARGUMENT_AFTER, argumentAfterList);
            }
            catch (Exception e) {
                LOGGER.warn("error profiling argument data after method execution, method: " + methodGenericString + " argument index: " + index + " globalPerRequestId: " + globalPerRequestId, (Throwable)e);
                ProfileRepository.setProfileState(ProfileState.FAILED);
            }
            ArrayList<MethodData> returnDataList = new ArrayList<MethodData>();
            if (invocationException == null) {
                try {
                    returnDataList.add(new MethodData(MethodDataType.RETURN, invocationReturnData == null ? null : invocationReturnData.getClass().getName(), invocationReturnData == null ? null : this.serdeHandlerRepository.getOrUpdateAndGetOrDefaultReturnDataSerdeHandler(invocation).serialize(invocationReturnData), 0));
                    methodDataMap.put(MethodDataType.RETURN, returnDataList);
                }
                catch (Exception e) {
                    LOGGER.warn("error profiling invocation return data after method execution, method: " + methodGenericString + " globalPerRequestId: " + globalPerRequestId, (Throwable)e);
                    ProfileRepository.setProfileState(ProfileState.FAILED);
                }
            } else {
                try {
                    returnDataList.add(new MethodData(MethodDataType.EXCEPTION, invocationException.getClass().getName(), this.serdeHandlerRepository.getExceptionDataSerdeHandler(methodGenericString, invocationException.getClass().getName()).serialize(invocationException), 0));
                    methodDataMap.put(MethodDataType.EXCEPTION, returnDataList);
                }
                catch (Exception e) {
                    LOGGER.warn("error profiling invocation exception data after method execution, method: " + methodGenericString + " globalPerRequestId: " + globalPerRequestId, (Throwable)e);
                    ProfileRepository.setProfileState(ProfileState.FAILED);
                }
            }
            try {
                ProfileRepository.addInterceptedData(methodGenericString, methodDataMap);
            }
            catch (Exception e) {
                LOGGER.error("error adding intercepted data against method : " + methodGenericString + " globalPerRequestId: " + globalPerRequestId);
                ProfileRepository.setProfileState(ProfileState.FAILED);
            }
        }
        catch (Exception e) {
            LOGGER.warn("error profiling data, method: " + methodGenericString + " globalPerRequestId: " + globalPerRequestId, (Throwable)e);
            ProfileRepository.setProfileState(ProfileState.FAILED);
        }
        if (invocationException != null) {
            throw invocationException;
        }
        return invocationReturnData;
    }
}

