/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gojira.core;

import com.flipkart.gojira.core.injectors.GuiceInjector;
import com.flipkart.gojira.requestsampling.RequestSamplingRepository;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.LongString;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RmqFilterHandler {
    protected static final Logger LOGGER = LoggerFactory.getLogger(RmqFilterHandler.class);

    protected abstract void handle(String var1, byte[] var2, byte[] var3, AMQP.BasicProperties var4, boolean var5);

    protected boolean isExchangeWhitelisted(String exchangeName) {
        List<Pattern> whitelistedExchanges = ((RequestSamplingRepository)GuiceInjector.getInjector().getInstance(RequestSamplingRepository.class)).getWhitelist();
        for (Pattern whitelistedExchange : whitelistedExchanges) {
            if (!whitelistedExchange.matcher(exchangeName).matches()) continue;
            return true;
        }
        LOGGER.info(String.format("exchange: %s is not whitelisted for Gojira... Hence ignoring!", exchangeName));
        return false;
    }

    protected final String getTestId(AMQP.BasicProperties basicProperties) {
        if (basicProperties == null || basicProperties.getHeaders() == null || basicProperties.getHeaders().isEmpty()) {
            LOGGER.error("Headers not present for RMQ");
            return null;
        }
        Map headersMap = basicProperties.getHeaders();
        try {
            for (Map.Entry header : headersMap.entrySet()) {
                if (!"X-GOJIRA-ID".equals(header.getKey()) || !(header.getValue() instanceof LongString)) continue;
                byte[] correlationIdAsByteArray = ((LongString)header.getValue()).getBytes();
                return new String(correlationIdAsByteArray, "UTF-8");
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to encode test headers", (Throwable)e);
        }
        return null;
    }
}

