/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gojira.core;

import com.flipkart.compare.TestCompareException;
import com.flipkart.gojira.compare.GojiraCompareHandlerRepository;
import com.flipkart.gojira.core.MethodDataInterceptorHandler;
import com.flipkart.gojira.core.ProfileRepository;
import com.flipkart.gojira.core.ProfileState;
import com.flipkart.gojira.core.injectors.GuiceInjector;
import com.flipkart.gojira.execute.TestExecutionException;
import com.flipkart.gojira.hash.HashHandlerUtil;
import com.flipkart.gojira.hash.TestHashHandler;
import com.flipkart.gojira.models.MethodData;
import com.flipkart.gojira.models.MethodDataType;
import com.flipkart.gojira.serde.SerdeHandlerRepository;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestMethodDataInterceptorHandler
implements MethodDataInterceptorHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestMethodDataInterceptorHandler.class);
    private GojiraCompareHandlerRepository gojiraCompareHandlerRepository = (GojiraCompareHandlerRepository)((Object)GuiceInjector.getInjector().getInstance(GojiraCompareHandlerRepository.class));
    private SerdeHandlerRepository serdeHandlerRepository = (SerdeHandlerRepository)GuiceInjector.getInjector().getInstance(SerdeHandlerRepository.class);

    @Override
    public Object handle(MethodInvocation invocation) throws Throwable {
        if (!ProfileRepository.getProfileState().equals((Object)ProfileState.INITIATED)) {
            throw new TestExecutionException("Test was not initiated.");
        }
        String genericMethodName = null;
        String globalPerRequestId = null;
        try {
            globalPerRequestId = ProfileRepository.getGlobalPerRequestID();
        }
        catch (Exception e) {
            LOGGER.error("error getting globalPerRequestId.", (Throwable)e);
            throw new TestExecutionException("error getting globalPerRequestId.", e);
        }
        try {
            genericMethodName = invocation.getMethod().toGenericString();
        }
        catch (Exception e) {
            LOGGER.error("error getting methodGenericString. globalPerRequestId: " + globalPerRequestId, (Throwable)e);
            throw new TestExecutionException("error getting methodGenericString. globalPerRequestId: " + globalPerRequestId, e);
        }
        if (ProfileRepository.getTestData() == null) {
            LOGGER.error("test data null. method: " + genericMethodName + " globalPerRequestId: " + globalPerRequestId);
            throw new TestExecutionException("test data null. method: " + genericMethodName + " globalPerRequestId: " + globalPerRequestId);
        }
        if (ProfileRepository.getTestData().getMethodDataMap() == null) {
            LOGGER.error("test data method data map null. method: " + genericMethodName + " globalPerRequestId: " + globalPerRequestId);
            throw new TestExecutionException("test data method data map null. method: " + genericMethodName + " globalPerRequestId: " + globalPerRequestId);
        }
        if (ProfileRepository.getTestData().getMethodDataMap().get(genericMethodName) == null) {
            LOGGER.error("test data method data map for method null. method: " + genericMethodName + " globalPerRequestId: " + globalPerRequestId);
            throw new TestExecutionException("test data method data map  for method null. method: " + genericMethodName + " globalPerRequestId: " + globalPerRequestId);
        }
        ConcurrentSkipListMap<Long, ConcurrentHashMap<MethodDataType, List<MethodData>>> perMethodAllEntries = ProfileRepository.getTestData().getMethodDataMap().get(genericMethodName);
        Map methodDataMap = null;
        for (Map.Entry<Long, ConcurrentHashMap<MethodDataType, List<MethodData>>> perMethodEntry : perMethodAllEntries.entrySet()) {
            Long perMethodEntryKey = perMethodEntry.getKey();
            Map perMethodEntryValue = perMethodEntry.getValue();
            if (perMethodEntryValue == null || perMethodEntryValue.isEmpty()) {
                LOGGER.error("methodDataMap null or empty, error running test. method: " + genericMethodName + " globalPerRequestId: " + globalPerRequestId);
                throw new TestExecutionException("methodDataMap null or empty, error running test. method: " + genericMethodName + " globalPerRequestId: " + globalPerRequestId);
            }
            if (!(perMethodEntryValue.containsKey((Object)MethodDataType.EXCEPTION) && !((List)perMethodEntryValue.get((Object)MethodDataType.EXCEPTION)).isEmpty() || perMethodEntryValue.containsKey((Object)MethodDataType.RETURN) && !((List)perMethodEntryValue.get((Object)MethodDataType.RETURN)).isEmpty())) {
                LOGGER.error("both return and exception data not present in methodDataMap, error running test. method: " + genericMethodName + " globalPerRequestId: " + globalPerRequestId);
                throw new TestExecutionException("both return and exception data not present in methodDataMap, error running test. method: " + genericMethodName + " globalPerRequestId: " + globalPerRequestId);
            }
            try {
                for (MethodData methodData : (List)perMethodEntryValue.get((Object)MethodDataType.ARGUMENT_BEFORE)) {
                    if (methodData == null) {
                        LOGGER.error("methodData before argument null, error running test. method: " + genericMethodName + " globalPerRequestId: " + globalPerRequestId);
                        throw new TestExecutionException("methodData before argument null, error running test. method: " + genericMethodName + " globalPerRequestId: " + globalPerRequestId);
                    }
                    if (methodData.getData() == null && invocation.getArguments()[methodData.getPosition()] == null) continue;
                    if (methodData.getData() == null || invocation.getArguments()[methodData.getPosition()] == null) {
                        LOGGER.error("error comparing during test: comparison failed method: " + genericMethodName + " globalPerRequestId: " + globalPerRequestId);
                        throw new TestCompareException("error comparing during test: comparison failed method: " + genericMethodName + " globalPerRequestId: " + globalPerRequestId);
                    }
                    TestHashHandler hashHandler = HashHandlerUtil.getHashHandler(invocation, methodData.getPosition());
                    this.gojiraCompareHandlerRepository.getOrUpdateAndGetOrDefaultMethodArgumentDataCompareHandler(invocation, methodData.getPosition()).compare(methodData.getData(), hashHandler == null ? this.serdeHandlerRepository.getOrUpdateAndGetOrDefaultMethodArgumentDataSerdeHandler(invocation, methodData.getPosition()).serialize(invocation.getArguments()[methodData.getPosition()]) : hashHandler.hash(this.serdeHandlerRepository.getOrUpdateAndGetOrDefaultMethodArgumentDataSerdeHandler(invocation, methodData.getPosition()).serialize(invocation.getArguments()[methodData.getPosition()])));
                }
                methodDataMap = perMethodEntryValue;
                ConcurrentHashMap<MethodDataType, List<MethodData>> concurrentCheckValue = perMethodAllEntries.remove(perMethodEntryKey);
                if (concurrentCheckValue != null) break;
            }
            catch (TestCompareException e) {
                LOGGER.warn("recorded method argument list does not match with current method arguments. trying with another set of recorded argument against the method. method: " + genericMethodName + " globalPerRequestId: " + globalPerRequestId);
            }
        }
        if (methodDataMap == null) {
            LOGGER.error("unable to find any matching argument(s) from the queue of arguments against method signature: " + genericMethodName + ". this could mean not ignored diffs in the comparison that is done for arguments before method execution. method: " + genericMethodName + " globalPerRequestId: " + globalPerRequestId);
            throw new TestCompareException("unable to find any matching argument(s) from the queue of arguments against method signature: " + genericMethodName + ". this could mean not ignored diffs in the comparison that is done for arguments before method execution. method: " + genericMethodName + " globalPerRequestId: " + globalPerRequestId);
        }
        if (methodDataMap.containsKey((Object)MethodDataType.ARGUMENT_AFTER) && !((List)methodDataMap.get((Object)MethodDataType.ARGUMENT_AFTER)).isEmpty()) {
            int index = -1;
            for (MethodData methodData : (List)methodDataMap.get((Object)MethodDataType.ARGUMENT_AFTER)) {
                if (methodData == null || methodData.getData() != null && methodData.getClassName() == null) {
                    LOGGER.error("argument " + index + " methodData or methodData.getData not null and methodData.className null, error running test.method: " + genericMethodName + " globalPerRequestId: " + globalPerRequestId);
                    throw new TestExecutionException("argument " + index + " methodData or methodData.getData not null and methodData.className null, error running test.method: " + genericMethodName + " globalPerRequestId: " + globalPerRequestId);
                }
                ++index;
                if (methodData.getData() == null) {
                    invocation.getArguments()[index] = null;
                    continue;
                }
                this.serdeHandlerRepository.getOrUpdateAndGetOrDefaultMethodArgumentDataSerdeHandler(invocation, methodData.getPosition()).deserializeToInstance(methodData.getData(), invocation.getArguments()[index]);
            }
        }
        if (methodDataMap.containsKey((Object)MethodDataType.EXCEPTION) && !((List)methodDataMap.get((Object)MethodDataType.EXCEPTION)).isEmpty()) {
            if (((List)methodDataMap.get((Object)MethodDataType.EXCEPTION)).get(0) == null || ((MethodData)((List)methodDataMap.get((Object)MethodDataType.EXCEPTION)).get(0)).getClassName() == null || ((MethodData)((List)methodDataMap.get((Object)MethodDataType.EXCEPTION)).get(0)).getData() == null) {
                LOGGER.error("exception methodData or methodData.className or methodData.data null, error running test.method: " + genericMethodName + " globalPerRequestId: " + globalPerRequestId);
                throw new TestExecutionException("exception methodData or methodData.className or methodData.data null, error running test.method: " + genericMethodName + " globalPerRequestId: " + globalPerRequestId);
            }
            LOGGER.info("Throwing exception that was captured while profiling.");
            throw (Throwable)this.serdeHandlerRepository.getExceptionDataSerdeHandler(genericMethodName, ((MethodData)((List)methodDataMap.get((Object)MethodDataType.EXCEPTION)).get(0)).getClassName()).deserialize(((MethodData)((List)methodDataMap.get((Object)MethodDataType.EXCEPTION)).get(0)).getData(), Class.forName(((MethodData)((List)methodDataMap.get((Object)MethodDataType.EXCEPTION)).get(0)).getClassName()));
        }
        if (methodDataMap.containsKey((Object)MethodDataType.RETURN) && !((List)methodDataMap.get((Object)MethodDataType.RETURN)).isEmpty()) {
            if (((List)methodDataMap.get((Object)MethodDataType.RETURN)).get(0) == null || ((MethodData)((List)methodDataMap.get((Object)MethodDataType.RETURN)).get(0)).getData() != null && ((MethodData)((List)methodDataMap.get((Object)MethodDataType.RETURN)).get(0)).getClassName() == null) {
                LOGGER.error("return methodData or methodData.getData not null and methodData.className null, error running test.method: " + genericMethodName + " globalPerRequestId: " + globalPerRequestId);
                throw new TestExecutionException("return methodData or methodData.getData not null and methodData.className null, error running test.method: " + genericMethodName + " globalPerRequestId: " + globalPerRequestId);
            }
            LOGGER.info("returning successfully from TestMethodDataInterceptorHandler.");
            return ((MethodData)((List)methodDataMap.get((Object)MethodDataType.RETURN)).get(0)).getData() == null ? null : this.serdeHandlerRepository.getOrUpdateAndGetOrDefaultReturnDataSerdeHandler(invocation).deserialize(((MethodData)((List)methodDataMap.get((Object)MethodDataType.RETURN)).get(0)).getData(), Class.forName(((MethodData)((List)methodDataMap.get((Object)MethodDataType.RETURN)).get(0)).getClassName()));
        }
        LOGGER.info("returning null from TestMethodDataInterceptorHandler. No return data or exception was profiled.");
        return null;
    }
}

