/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gojira.external.http;

import com.flipkart.gojira.core.injectors.TestExecutionInjector;
import com.flipkart.gojira.external.ExternalConfigRepository;
import com.flipkart.gojira.external.Managed;
import com.flipkart.gojira.external.SetupException;
import com.flipkart.gojira.external.ShutdownException;
import com.flipkart.gojira.external.config.ExternalConfig;
import com.flipkart.gojira.external.config.HttpConfig;
import com.flipkart.gojira.external.http.IHttpManager;
import com.flipkart.gojira.models.http.HttpTestDataType;
import java.util.Map;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum HttpManager implements IHttpManager,
Managed
{
    HTTP_MANAGER;

    private static final Logger LOGGER;

    @Override
    public void setup() throws SetupException {
        try {
            Map<String, ExternalConfig> externalConfigMap = ((ExternalConfigRepository)TestExecutionInjector.getInjector().getInstance(ExternalConfigRepository.class)).getExternalConfigByType(HttpTestDataType.class);
            for (Map.Entry<String, ExternalConfig> entry : externalConfigMap.entrySet()) {
                if (entry.getValue() == null) continue;
                HttpConfig httpConfig = (HttpConfig)entry.getValue();
                clientMap.put(entry.getKey(), new DefaultAsyncHttpClient((AsyncHttpClientConfig)new DefaultAsyncHttpClientConfig.Builder().setConnectTimeout(httpConfig.getConnectionTimeout()).setMaxConnections(httpConfig.getMaxConnections()).setMaxConnectionsPerHost(httpConfig.getMaxConnections()).setKeepAlive(true).setRequestTimeout(httpConfig.getOperationTimeout()).build()));
            }
        }
        catch (Exception e) {
            LOGGER.error("error setting up http connections.", (Throwable)e);
            throw new SetupException("error setting up http connections.", e);
        }
    }

    @Override
    public DefaultAsyncHttpClient getClient(String key) {
        return (DefaultAsyncHttpClient)clientMap.get(key);
    }

    @Override
    public void shutdown() throws ShutdownException {
        try {
            for (Map.Entry entry : clientMap.entrySet()) {
                ((DefaultAsyncHttpClient)entry.getValue()).close();
            }
        }
        catch (Exception e) {
            LOGGER.error("error closing http connections.", (Throwable)e);
            throw new ShutdownException("error closing http connections.", e);
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(HttpManager.class);
    }
}

