/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.core.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.AbstractConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class YamlConfiguration
extends AbstractConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(YamlConfiguration.class);
    private Map<String, Object> configTab = new HashMap<String, Object>();

    public YamlConfiguration() {
    }

    public YamlConfiguration(String path) throws IOException {
        FileReader reader = new FileReader(path);
        this.load(reader);
        reader.close();
    }

    public YamlConfiguration(File file) throws IOException {
        FileReader reader = new FileReader(file);
        this.load(reader);
        reader.close();
    }

    public YamlConfiguration(URL url) throws IOException {
        InputStreamReader reader = new InputStreamReader(url.openStream());
        this.load(reader);
        reader.close();
    }

    public YamlConfiguration(BufferedReader reader) throws IOException {
        this.load(reader);
        reader.close();
    }

    public void addAll(YamlConfiguration ... configurations) {
        for (YamlConfiguration config : configurations) {
            config.getKeys().forEachRemaining(key -> this.configTab.put((String)key, config.getProperty((String)key)));
        }
    }

    public boolean isEmpty() {
        return this.configTab.isEmpty();
    }

    public boolean containsKey(String key) {
        return this.configTab.containsKey(key);
    }

    public Object getProperty(String key) {
        return this.configTab.get(key);
    }

    public Iterator<String> getKeys() {
        return this.configTab.keySet().iterator();
    }

    protected void addPropertyDirect(String key, Object value) {
    }

    private void load(Reader in) {
        Yaml yaml = new Yaml();
        Map dom = (Map)yaml.load(in);
        this.flatten(null, dom);
        LOGGER.debug("yaml configuration loaded: {}", this.configTab);
    }

    private void flatten(String prefix, Map<?, ?> dom) {
        Set<?> keys = dom.keySet();
        for (Object key : keys) {
            String name = prefix != null ? prefix + "." + key.toString() : key.toString();
            Object value = dom.get(key);
            if (value instanceof Map) {
                this.flatten(name, (Map)value);
                continue;
            }
            this.configTab.put(name, value);
        }
    }
}

