/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.core;

import com.flipkart.gjex.core.logging.Logging;
import com.flipkart.gjex.core.setup.Bootstrap;
import com.flipkart.gjex.core.setup.Environment;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;

public abstract class Application
implements Logging {
    private static final MessageFormat STARTUP_DISPLAY = new MessageFormat("\n*************************************************************************\n \u2554\u2550\u2557 \u2566\u2554\u2550\u2557\u2550\u2557 \u2566      Application name : {0} \n \u2551 \u2566 \u2551\u2551\u2563 \u2554\u2569\u2566\u255d      Startup Time : {1} ms\n \u255a\u2550\u255d\u255a\u255d\u255a\u2550\u255d\u2569 \u255a\u2550      Host Name: {2} \n *************************************************************************");
    private String hostName;

    public Application() {
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public abstract void initialize(Bootstrap var1);

    public abstract void run(Environment var1) throws Exception;

    public final void run(String[] arguments) throws Exception {
        this.info("** GJEX starting up... **");
        long start = System.currentTimeMillis();
        Bootstrap bootstrap = new Bootstrap(this);
        this.initialize(bootstrap);
        Environment environment = new Environment(this.getName(), bootstrap.getMetricRegistry());
        bootstrap.run(environment);
        this.run(environment);
        Object[] displayArgs = new Object[]{this.getName(), System.currentTimeMillis() - start, this.hostName};
        this.info(STARTUP_DISPLAY.format(displayArgs));
        this.info("** GJEX startup complete **");
    }
}

