/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.core.setup;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.jmx.JmxReporter;
import com.codahale.metrics.jvm.BufferPoolMetricSet;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import com.flipkart.gjex.core.Application;
import com.flipkart.gjex.core.Bundle;
import com.flipkart.gjex.core.filter.Filter;
import com.flipkart.gjex.core.logging.Logging;
import com.flipkart.gjex.core.service.Service;
import com.flipkart.gjex.core.setup.Environment;
import com.flipkart.gjex.core.setup.HealthCheckRegistry;
import com.flipkart.gjex.core.tracing.TracingSampler;
import com.google.common.collect.Lists;
import java.lang.management.ManagementFactory;
import java.util.LinkedList;
import java.util.List;

public class Bootstrap
implements Logging {
    private final Application application;
    private final MetricRegistry metricRegistry;
    private final List<Bundle> bundles;
    private ClassLoader classLoader;
    List<Service> services;
    List<Filter> filters;
    List<TracingSampler> tracingSamplers;
    private HealthCheckRegistry healthCheckRegistry;

    public Bootstrap(Application application) {
        this.application = application;
        this.metricRegistry = new MetricRegistry();
        this.bundles = Lists.newArrayList();
        this.getMetricRegistry().register("jvm.buffers", (Metric)new BufferPoolMetricSet(ManagementFactory.getPlatformMBeanServer()));
        this.getMetricRegistry().register("jvm.gc", (Metric)new GarbageCollectorMetricSet());
        this.getMetricRegistry().register("jvm.memory", (Metric)new MemoryUsageGaugeSet());
        this.getMetricRegistry().register("jvm.threads", (Metric)new ThreadStatesGaugeSet());
        JmxReporter.forRegistry((MetricRegistry)this.getMetricRegistry()).build().start();
    }

    public Application getApplication() {
        return this.application;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void addBundle(Bundle bundle) {
        bundle.initialize(this);
        this.bundles.add(bundle);
    }

    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    public List<Service> getServices() {
        return this.services;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public List<TracingSampler> getTracingSamplers() {
        return this.tracingSamplers;
    }

    public void run(Environment environment) throws Exception {
        this.services = new LinkedList<Service>();
        this.filters = new LinkedList<Filter>();
        this.healthCheckRegistry = environment.getHealthCheckRegistry();
        for (Bundle bundle : this.bundles) {
            bundle.run(environment);
            this.services.addAll(bundle.getServices());
            this.filters.addAll(bundle.getFilters());
            this.tracingSamplers = bundle.getTracingSamplers();
            bundle.getHealthChecks().forEach(hc -> this.healthCheckRegistry.register(hc.getClass().getSimpleName(), (HealthCheck)hc));
        }
        this.services.forEach(service -> {
            try {
                service.start();
            }
            catch (Exception e) {
                this.error("Error starting a Service : " + service.getClass().getName(), e);
                throw new RuntimeException(e);
            }
        });
        this.filters.forEach(filter -> {
            try {
                filter.init();
            }
            catch (Exception e) {
                this.error("Error initializing a Filter : " + filter.getClass().getName(), e);
                throw new RuntimeException(e);
            }
        });
        this.registerServicesForShutdown();
    }

    public HealthCheckRegistry getHealthCheckRegistry() {
        return this.healthCheckRegistry;
    }

    private void registerServicesForShutdown() throws Exception {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                System.out.println("*** Shutting down GJEX server since JVM is shutting down");
                Bootstrap.this.services.forEach(Service::stop);
                Bootstrap.this.filters.forEach(Filter::destroy);
                System.out.println("*** Server shut down");
            }
        });
    }
}

