/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.core.tracing;

import com.flipkart.gjex.core.logging.Logging;
import com.flipkart.gjex.core.tracing.CountingSampler;
import com.flipkart.gjex.core.tracing.TracingSampler;
import java.util.HashMap;
import java.util.Map;

public class ConfigurableTracingSampler
implements TracingSampler,
Logging {
    private boolean isTraceEnabled = false;
    private Map<String, CountingSampler> componentMap = new HashMap<String, CountingSampler>();

    @Override
    public boolean isSampled(String component) {
        boolean isSampled = this.isTraceEnabled(component);
        if (!isSampled) {
            return false;
        }
        CountingSampler sampler = this.componentMap.get(component);
        if (sampler != null) {
            return sampler.isSampled();
        }
        return isSampled;
    }

    @Override
    public void initializeSamplerFor(String component, float rate) {
        CountingSampler sampler = this.componentMap.get(component);
        if (sampler == null) {
            sampler = new CountingSampler(rate);
            this.componentMap.put(component, sampler);
        }
    }

    protected boolean isTraceEnabled(String component) {
        return this.isTraceEnabled;
    }

    protected void setIsTraceEnabled(boolean traceEnabled) {
        if (this.isTraceEnabled && !traceEnabled) {
            this.resetSamplers();
        }
        this.isTraceEnabled = traceEnabled;
    }

    protected void resetSamplers() {
        this.componentMap.clear();
    }
}

