/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.core;

import com.flipkart.gjex.core.GJEXConfiguration;
import com.flipkart.gjex.core.Generics;
import com.flipkart.gjex.core.config.ArgumentParserWrapper;
import com.flipkart.gjex.core.logging.Logging;
import com.flipkart.gjex.core.setup.Bootstrap;
import com.flipkart.gjex.core.setup.Environment;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Map;
import net.sourceforge.argparse4j.inf.Namespace;

public abstract class Application<T extends GJEXConfiguration, U extends Map>
implements Logging {
    private static final MessageFormat STARTUP_DISPLAY = new MessageFormat("\n*************************************************************************\n \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd      Application name : {0} \n \ufffd\ufffd\ufffd \ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd      Startup Time : {1} ms\n \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd      Host Name: {2} \n *************************************************************************");
    private String hostName;
    private final ArgumentParserWrapper argumentParser = new ArgumentParserWrapper();

    public Application() {
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public abstract void initialize(Bootstrap<T, U> var1);

    public abstract void run(T var1, U var2, Environment var3) throws Exception;

    public final void run(String ... arguments) throws Exception {
        this.info("** GJEX starting up... **");
        long start = System.currentTimeMillis();
        Namespace namespace = this.argumentParser.parseArguments(arguments);
        String configFilePath = namespace.getString("file");
        Bootstrap bootstrap = new Bootstrap(this, configFilePath, this.getConfigurationClass());
        this.initialize(bootstrap);
        Environment environment = new Environment(this.getName(), bootstrap.getMetricRegistry());
        bootstrap.run(environment);
        this.run(bootstrap.getConfiguration(), bootstrap.getConfigMap(), environment);
        Object[] displayArgs = new Object[]{this.getName(), System.currentTimeMillis() - start, this.hostName};
        this.info(STARTUP_DISPLAY.format(displayArgs));
        this.info("** GJEX startup complete **");
    }

    public Class<T> getConfigurationClass() {
        return Generics.getTypeParameter(this.getClass(), GJEXConfiguration.class);
    }
}

