/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.core.web.filter;

import com.flipkart.gjex.core.logging.Logging;
import java.io.IOException;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Singleton
@Named(value="HttpAccessLogFilter")
public class HttpAccessLogFilter
implements Filter,
Logging {
    private long startTime;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.startTime = System.currentTimeMillis();
        chain.doFilter(request, response);
        StringBuilder sb = new StringBuilder();
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            HttpServletResponse httpServletResponse = (HttpServletResponse)response;
            sb.append(httpServletRequest.getHeader("x-forwarded-for")).append(" ").append(httpServletRequest.getRequestURI()).append(" ").append(httpServletResponse.getStatus()).append(" ").append(httpServletResponse.getHeader("Content-Length")).append(" ");
        } else {
            sb.append("Did not get HTTP request").append(" ");
        }
        sb.append(request.getRemoteAddr()).append(" ");
        sb.append(System.currentTimeMillis() - this.startTime);
        this.error(sb.toString());
    }

    public void destroy() {
    }
}

