/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.core.filter.http;

import com.flipkart.gjex.core.filter.RequestParams;
import com.flipkart.gjex.core.filter.ResponseParams;
import com.flipkart.gjex.core.filter.http.HttpFilter;
import java.util.Set;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AccessLogHttpFilter
extends HttpFilter {
    private long startTime;
    private StringBuilder sb;

    @Override
    public void doProcessRequest(RequestParams<ServletRequest, Set<String>> requestParams) {
        this.startTime = System.currentTimeMillis();
        this.sb = new StringBuilder();
    }

    @Override
    public void doProcessResponseHeaders(Set<String> responseHeaders) {
        if (this.getRequest() instanceof HttpServletRequest && this.getResponse() instanceof HttpServletResponse) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)this.getRequest();
            HttpServletResponse httpServletResponse = (HttpServletResponse)this.getResponse();
            this.sb.append(httpServletRequest.getHeader("x-forwarded-for")).append(" ").append(httpServletRequest.getRequestURI()).append(" ").append(httpServletResponse.getStatus()).append(" ").append(httpServletResponse.getHeader("Content-Length")).append(" ");
        } else {
            this.sb.append("Did not get HTTP request").append(" ");
        }
    }

    @Override
    public void doProcessResponse(ResponseParams<ServletResponse> response) {
        this.sb.append(this.getRequest().getRemoteAddr()).append(" ");
        this.sb.append(System.currentTimeMillis() - this.startTime);
        this.info("access-log", this.sb.toString());
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public long getStartTime() {
        return this.startTime;
    }

    public StringBuilder getSb() {
        return this.sb;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setSb(StringBuilder sb) {
        this.sb = sb;
    }

    @Override
    public String toString() {
        return "AccessLogHttpFilter(startTime=" + this.getStartTime() + ", sb=" + this.getSb() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccessLogHttpFilter)) {
            return false;
        }
        AccessLogHttpFilter other = (AccessLogHttpFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStartTime() != other.getStartTime()) {
            return false;
        }
        StringBuilder this$sb = this.getSb();
        StringBuilder other$sb = other.getSb();
        return !(this$sb == null ? other$sb != null : !this$sb.equals(other$sb));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AccessLogHttpFilter;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $startTime = this.getStartTime();
        result = result * 59 + (int)($startTime >>> 32 ^ $startTime);
        StringBuilder $sb = this.getSb();
        result = result * 59 + ($sb == null ? 43 : $sb.hashCode());
        return result;
    }
}

