/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.core.filter.http;

import com.flipkart.gjex.core.filter.RequestParams;
import com.flipkart.gjex.core.filter.ResponseParams;
import com.flipkart.gjex.core.filter.http.HttpFilter;
import java.util.Set;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;

public class AccessLogHttpFilter
extends HttpFilter {
    protected long startTime;
    protected Logger logger = this.getLoggerWithName("ACCESS-LOG");
    protected static final String CONTENT_LENGTH_HEADER = "Content-Length";
    protected static final String X_FORWARDED_FOR_HEADER = "x-forwarded-for";

    @Override
    public void doProcessRequest(RequestParams<ServletRequest, Set<String>> requestParamsInput) {
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public void doProcessResponse(ResponseParams<ServletResponse> response) {
        if (this.logger.isInfoEnabled()) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)this.request;
            HttpServletResponse httpServletResponse = (HttpServletResponse)response.getResponse();
            this.logger.info("{} {} {} {} {} {}", new Object[]{httpServletRequest.getHeader(X_FORWARDED_FOR_HEADER), httpServletRequest.getRequestURI(), httpServletResponse.getStatus(), httpServletResponse.getHeader(CONTENT_LENGTH_HEADER), this.request.getRemoteAddr(), System.currentTimeMillis() - this.startTime});
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }
}

