/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.core.filter.http;

import com.flipkart.gjex.core.filter.RequestParams;
import com.flipkart.gjex.core.filter.http.HttpFilter;
import com.flipkart.gjex.core.logging.Logging;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;

public class AccessLogHttpFilter
extends HttpFilter
implements Logging {
    protected long startTime;
    protected RequestParams<Set<String>> requestParams;
    protected static Logger logger = Logging.loggerWithName("ACCESS-LOG");
    protected static final String CONTENT_LENGTH_HEADER = "Content-Length";

    @Override
    public HttpFilter getInstance() {
        return new AccessLogHttpFilter();
    }

    @Override
    public void doProcessRequest(ServletRequest req, RequestParams<Set<String>> requestParamsInput) {
        this.startTime = System.currentTimeMillis();
        this.requestParams = requestParamsInput;
    }

    @Override
    public void doProcessResponse(ServletResponse response) {
        if (logger.isInfoEnabled()) {
            HttpServletResponse httpServletResponse = (HttpServletResponse)response;
            logger.info("{} {} {} {} {}", new Object[]{this.requestParams.getClientIp(), this.requestParams.getResourcePath(), httpServletResponse.getStatus(), httpServletResponse.getHeader(CONTENT_LENGTH_HEADER), System.currentTimeMillis() - this.startTime});
        }
    }
}

