/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.core.filter.grpc;

import com.flipkart.gjex.core.context.AccessLogContext;
import com.flipkart.gjex.core.filter.RequestParams;
import com.flipkart.gjex.core.filter.grpc.GrpcFilter;
import com.flipkart.gjex.core.logging.Logging;
import com.google.protobuf.GeneratedMessageV3;
import io.grpc.Metadata;
import org.slf4j.Logger;

public final class AccessLogGrpcFilter<R extends GeneratedMessageV3, S extends GeneratedMessageV3>
extends GrpcFilter<R, S>
implements Logging {
    private long startTime;
    private RequestParams<Metadata> requestParams;
    private String format;
    private static final Logger logger = Logging.loggerWithName("ACCESS-LOG");

    public AccessLogGrpcFilter(String format) {
        this.format = format;
    }

    @Override
    public void doProcessRequest(R req, RequestParams<Metadata> requestParamsInput) {
        this.startTime = System.currentTimeMillis();
        this.requestParams = requestParamsInput;
    }

    @Override
    public void doProcessResponseHeaders(Metadata responseHeaders) {
    }

    @Override
    public void doProcessResponse(S response) {
        AccessLogContext accessLogContext = AccessLogContext.builder().clientIp(this.requestParams.getClientIp()).resourcePath(this.requestParams.getResourcePath()).contentLength(response.getSerializedSize()).responseTime(System.currentTimeMillis() - this.startTime).build();
        logger.info(accessLogContext.format(this.format));
    }

    @Override
    public GrpcFilter<R, S> getInstance() {
        return new AccessLogGrpcFilter<R, S>(this.format);
    }
}

