/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.core.service;

import com.flipkart.gjex.core.logging.Logging;
import com.flipkart.gjex.core.service.Service;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class AbstractService
implements Service,
Logging {
    public static final String STOPPED = "STOPPED";
    public static final String FAILED = "FAILED";
    public static final String STARTING = "STARTING";
    public static final String STARTED = "STARTED";
    public static final String STOPPING = "STOPPING";
    public static final String RUNNING = "RUNNING";
    private static final int FAILED_STATE = -1;
    private static final int STOPPED_STATE = 0;
    private static final int STARTING_STATE = 1;
    private static final int STARTED_STATE = 2;
    private static final int STOPPING_STATE = 3;
    private final CopyOnWriteArrayList<Service.Listener> listeners = new CopyOnWriteArrayList();
    private final Object lock = new Object();
    private volatile int state = 0;
    private long stopTimeout = 30000L;

    protected void doStart() throws Exception {
    }

    protected void doStop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void start() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.state == 2 || this.state == 1) {
                    return;
                }
                this.setStarting();
                this.doStart();
                this.setStarted();
            }
            catch (Throwable e) {
                this.setFailed(e);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void stop() {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.state == 3 || this.state == 0) {
                    return;
                }
                this.setStopping();
                this.doStop();
                this.setStopped();
            }
            catch (Throwable e) {
                this.setFailed(e);
            }
        }
    }

    @Override
    public boolean isRunning() {
        int tempState = this.state;
        return tempState == 2 || this.state == 1;
    }

    @Override
    public boolean isStarted() {
        return this.state == 2;
    }

    @Override
    public boolean isStarting() {
        return this.state == 1;
    }

    @Override
    public boolean isStopping() {
        return this.state == 3;
    }

    @Override
    public boolean isStopped() {
        return this.state == 0;
    }

    @Override
    public boolean isFailed() {
        return this.state == -1;
    }

    @Override
    public void addServiceListener(Service.Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeServiceListener(Service.Listener listener) {
        this.listeners.remove(listener);
    }

    public String getState() {
        switch (this.state) {
            case -1: {
                return FAILED;
            }
            case 1: {
                return STARTING;
            }
            case 2: {
                return STARTED;
            }
            case 3: {
                return STOPPING;
            }
            case 0: {
                return STOPPED;
            }
        }
        return null;
    }

    public static String getState(Service service) {
        if (service.isStarting()) {
            return STARTING;
        }
        if (service.isStarted()) {
            return STARTED;
        }
        if (service.isStopping()) {
            return STOPPING;
        }
        if (service.isStopped()) {
            return STOPPED;
        }
        return FAILED;
    }

    private void setStarted() {
        this.state = 2;
        this.logDebug("STARTED {}", null, this);
        this.listeners.forEach(listener -> listener.serviceStarted(this));
    }

    private void setStarting() {
        this.logDebug("starting {}", null, this);
        this.state = 1;
        this.listeners.forEach(listener -> listener.serviceStarting(this));
    }

    private void setStopping() {
        this.logDebug("stopping {}", null, this);
        this.state = 3;
        this.listeners.forEach(listener -> listener.serviceStopping(this));
    }

    private void setStopped() {
        this.state = 0;
        this.logDebug("{} {}", null, STOPPED, this);
        this.listeners.forEach(listener -> listener.serviceStopped(this));
    }

    private void setFailed(Throwable th) {
        this.state = -1;
        this.warnLog("FAILED " + this + ": " + th, th);
        this.listeners.forEach(listener -> listener.serviceFailure(this, th));
    }

    public long getStopTimeout() {
        return this.stopTimeout;
    }

    public void setStopTimeout(long stopTimeout) {
        this.stopTimeout = stopTimeout;
    }
}

