/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.core.filter.http;

import com.flipkart.gjex.core.context.AccessLogContext;
import com.flipkart.gjex.core.filter.RequestParams;
import com.flipkart.gjex.core.filter.http.HttpFilter;
import com.flipkart.gjex.core.logging.Logging;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.util.Map;
import java.util.Optional;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;

public class AccessLogHttpFilter
extends HttpFilter
implements Logging {
    protected long startTime;
    protected AccessLogContext.AccessLogContextBuilder accessLogContextBuilder;
    private static final Logger logger = Logging.loggerWithName("ACCESS-LOG");
    protected static String format;

    public static void setFormat(String format) {
        AccessLogHttpFilter.format = format;
    }

    @Override
    public HttpFilter getInstance() {
        return new AccessLogHttpFilter();
    }

    @Override
    public void doProcessRequest(ServletRequest req, RequestParams<Map<String, String>> requestParamsInput) {
        this.startTime = System.currentTimeMillis();
        this.accessLogContextBuilder = AccessLogContext.builder().clientIp(requestParamsInput.getClientIp()).resourcePath(requestParamsInput.getResourcePath()).protocol(req.getProtocol()).method(requestParamsInput.getMethod()).headers(requestParamsInput.getMetadata());
    }

    @Override
    public void doProcessResponseHeaders(Map<String, String> responseHeaders) {
    }

    @Override
    public void doProcessResponse(ServletResponse response) {
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        if (AccessLogHttpFilter.isSuccess(httpServletResponse.getStatus())) {
            int contentLength = Optional.ofNullable(httpServletResponse.getHeader(HttpHeaderNames.CONTENT_LENGTH.toString())).map(Integer::parseInt).orElse(0);
            this.accessLogContextBuilder.contentLength(contentLength);
        } else {
            this.accessLogContextBuilder.contentLength(0);
        }
        this.accessLogContextBuilder.responseStatus(httpServletResponse.getStatus()).responseTime(System.currentTimeMillis() - this.startTime);
        logger.info(this.accessLogContextBuilder.build().format(format));
    }

    @Override
    public void doHandleException(Exception e) {
        this.accessLogContextBuilder.contentLength(0).responseStatus(500).responseTime(System.currentTimeMillis() - this.startTime);
        logger.info(this.accessLogContextBuilder.build().format(format));
    }

    private static boolean isSuccess(int code) {
        return 200 <= code && code <= 299;
    }
}

