/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.core.config;

import com.flipkart.gjex.core.config.ConfigurationException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileLocator {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileLocator.class);
    private static final String DEPLOYED_CONFIG_ROOT = FileLocator.class.getClassLoader().getResource("packaged").getPath();

    public static File findUniqueFile(String fileName) throws ConfigurationException {
        return FileLocator.findUniqueFile(fileName, null);
    }

    public static File findUniqueFile(String fileName, String path) throws ConfigurationException {
        File[] files = FileLocator.findFiles(fileName, path);
        if (files.length == 0) {
            StringBuilder errorMessage = new StringBuilder("No file found that matches specified name : ");
            errorMessage.append(fileName);
            if (path != null) {
                errorMessage.append(" under path " + path);
            }
            LOGGER.error(errorMessage.toString());
            throw new RuntimeException(errorMessage.toString());
        }
        if (files.length > 1) {
            StringBuilder foundFiles = new StringBuilder();
            for (int i = 0; i < files.length; ++i) {
                foundFiles.append(files[i].getAbsolutePath() + "\n");
            }
            StringBuffer errorMessage = new StringBuffer("Multiple files found that match specified name : ");
            errorMessage.append(fileName);
            if (path != null) {
                errorMessage.append(" under path " + path);
            }
            errorMessage.append(" as: \n ");
            errorMessage.append(foundFiles.toString());
            LOGGER.error(errorMessage.toString());
            throw new RuntimeException(errorMessage.toString());
        }
        return files[0];
    }

    public static File[] findFiles(String fileName) {
        return FileLocator.findFiles(fileName, null);
    }

    public static File[] findFiles(String fileName, String path) {
        return FileLocator.findFiles(fileName, path, false);
    }

    public static File[] findDirectories(String directoryName, String path) {
        return FileLocator.findFiles(directoryName, path, true);
    }

    private static File[] findFiles(String fileName, String path, boolean isDirectory) {
        File pathFile;
        File projectRootFolder = null;
        projectRootFolder = path != null ? ((pathFile = new File(path)).isAbsolute() || pathFile.isDirectory() ? pathFile : new File(DEPLOYED_CONFIG_ROOT, path)) : new File(DEPLOYED_CONFIG_ROOT);
        ArrayList<File> locatedFiles = new ArrayList<File>();
        FileLocator.locateFiles(fileName, locatedFiles, projectRootFolder, false, isDirectory);
        if (locatedFiles.size() == 0) {
            try {
                Enumeration<URL> enumeration = FileLocator.class.getClassLoader().getResources(fileName);
                while (enumeration.hasMoreElements()) {
                    URL resource = enumeration.nextElement();
                    if (resource.getFile().contains(".jar!") && !isDirectory) {
                        locatedFiles.add(FileLocator.getTempFileFromResource(fileName, resource.openStream()));
                        continue;
                    }
                    locatedFiles.add(new File(resource.getFile()));
                }
            }
            catch (IOException e) {
                LOGGER.error("Unable to locate files that match: " + fileName, (Throwable)e);
            }
        }
        return locatedFiles.toArray(new File[locatedFiles.size()]);
    }

    private static File getTempFileFromResource(String fileName, InputStream input) throws IOException {
        int read;
        File tempFile = File.createTempFile(fileName, null);
        FileOutputStream out = new FileOutputStream(tempFile);
        byte[] bytes = new byte[1024];
        while ((read = input.read(bytes)) != -1) {
            ((OutputStream)out).write(bytes, 0, read);
        }
        out.flush();
        ((OutputStream)out).close();
        input.close();
        tempFile.deleteOnExit();
        return tempFile;
    }

    private static void locateFiles(String fileName, ArrayList<File> locatedFiles, File file, boolean isConfigFolder, boolean isDirectory) {
        fileName = fileName.trim();
        if (file.exists()) {
            if (file.isDirectory()) {
                if (!isConfigFolder) {
                    isConfigFolder = file.getName().equalsIgnoreCase("packaged");
                }
                File[] files = file.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    FileLocator.locateFiles(fileName, locatedFiles, files[i], isConfigFolder, isDirectory);
                }
            }
            if (isConfigFolder && file.getName().equalsIgnoreCase(fileName) && isDirectory ^ file.isFile()) {
                locatedFiles.add(file);
            }
        }
    }
}

