/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.core.setup;

import io.dropwizard.metrics5.Metric;
import io.dropwizard.metrics5.MetricFilter;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.jmx.JmxReporter;
import io.dropwizard.metrics5.jvm.BufferPoolMetricSet;
import io.dropwizard.metrics5.jvm.GarbageCollectorMetricSet;
import io.dropwizard.metrics5.jvm.MemoryUsageGaugeSet;
import io.dropwizard.metrics5.jvm.ThreadStatesGaugeSet;
import io.prometheus.metrics.instrumentation.dropwizard5.DropwizardExports;
import io.prometheus.metrics.model.registry.MultiCollector;
import io.prometheus.metrics.model.registry.PrometheusRegistry;
import java.lang.management.ManagementFactory;

public class AppMetricsRegistry {
    private final MetricRegistry metricRegistry;
    private final PrometheusRegistry prometheusRegistry;

    public AppMetricsRegistry(MetricRegistry metricRegistry, PrometheusRegistry prometheusRegistry) {
        this.metricRegistry = metricRegistry;
        this.prometheusRegistry = prometheusRegistry;
        this.registerJVMMetrics();
        this.registerPrometheusDropwizardExports();
        JmxReporter.forRegistry((MetricRegistry)metricRegistry).build().start();
    }

    public AppMetricsRegistry(MetricRegistry metricRegistry) {
        this(metricRegistry, PrometheusRegistry.defaultRegistry);
    }

    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    public PrometheusRegistry getPrometheusRegistry() {
        return this.prometheusRegistry;
    }

    private void registerPrometheusDropwizardExports() {
        this.prometheusRegistry.register((MultiCollector)new DropwizardExports(this.metricRegistry, MetricFilter.ALL));
    }

    private void registerJVMMetrics() {
        this.metricRegistry.register("jvm.buffers", (Metric)new BufferPoolMetricSet(ManagementFactory.getPlatformMBeanServer()));
        this.metricRegistry.register("jvm.gc", (Metric)new GarbageCollectorMetricSet());
        this.metricRegistry.register("jvm.memory", (Metric)new MemoryUsageGaugeSet());
        this.metricRegistry.register("jvm.threads", (Metric)new ThreadStatesGaugeSet());
    }
}

