/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.gjex.core.setup;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.gjex.core.Application;
import com.flipkart.gjex.core.Bundle;
import com.flipkart.gjex.core.GJEXConfiguration;
import com.flipkart.gjex.core.GJEXError;
import com.flipkart.gjex.core.GJEXObjectMapper;
import com.flipkart.gjex.core.config.ConfigurationException;
import com.flipkart.gjex.core.config.ConfigurationFactory;
import com.flipkart.gjex.core.config.ConfigurationFactoryFactory;
import com.flipkart.gjex.core.config.ConfigurationSourceProvider;
import com.flipkart.gjex.core.config.DefaultConfigurationFactoryFactory;
import com.flipkart.gjex.core.config.FileConfigurationSourceProvider;
import com.flipkart.gjex.core.filter.Filter;
import com.flipkart.gjex.core.filter.grpc.GrpcFilter;
import com.flipkart.gjex.core.filter.http.HttpFilter;
import com.flipkart.gjex.core.healthcheck.HealthCheckRegistry;
import com.flipkart.gjex.core.job.ScheduledJob;
import com.flipkart.gjex.core.logging.Logging;
import com.flipkart.gjex.core.service.Service;
import com.flipkart.gjex.core.setup.AppMetricsRegistry;
import com.flipkart.gjex.core.setup.Environment;
import com.flipkart.gjex.core.tracing.TracingSampler;
import com.flipkart.gjex.core.util.Pair;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.health.HealthCheck;
import io.prometheus.metrics.model.registry.PrometheusRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class Bootstrap<T extends GJEXConfiguration, U extends Map>
implements Logging {
    private final Application<T, U> application;
    private final AppMetricsRegistry appMetricsRegistry;
    private final List<Bundle<? super T, ? super U>> bundles;
    private final ObjectMapper objectMapper;
    private final String configPath;
    private final Class<T> configurationClass;
    private ClassLoader classLoader;
    private ConfigurationFactoryFactory<T, U> configurationFactoryFactory;
    private ConfigurationSourceProvider configurationSourceProvider;
    private ValidatorFactory validatorFactory;
    private T configuration;
    private U configMap;
    private List<Service> services;
    private List<GrpcFilter> grpcFilters;
    private List<HttpFilter> httpFilters;
    private List<TracingSampler> tracingSamplers;
    private List<ScheduledJob> scheduledJobs;
    private HealthCheckRegistry healthCheckRegistry;

    public Bootstrap(Application<T, U> application, String configPath, Class<T> configurationClass) {
        this.configurationClass = configurationClass;
        this.configPath = configPath;
        this.application = application;
        this.appMetricsRegistry = new AppMetricsRegistry(new MetricRegistry(), PrometheusRegistry.defaultRegistry);
        this.bundles = Lists.newArrayList();
        this.objectMapper = GJEXObjectMapper.newObjectMapper();
        this.classLoader = Thread.currentThread().getContextClassLoader();
        this.configurationFactoryFactory = new DefaultConfigurationFactoryFactory();
        this.configurationSourceProvider = new FileConfigurationSourceProvider();
        this.validatorFactory = Validation.buildDefaultValidatorFactory();
        this.initializeConfig();
    }

    public Application<T, U> getApplication() {
        return this.application;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void addBundle(Bundle<? super T, ? super U> bundle) {
        Preconditions.checkState((!this.bundles.contains(bundle) ? 1 : 0) != 0, (Object)"bundles can be initialized only once");
        bundle.initialize(this);
        this.bundles.add(bundle);
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public MetricRegistry getMetricRegistry() {
        return this.appMetricsRegistry.getMetricRegistry();
    }

    public AppMetricsRegistry getAppMetricsRegistry() {
        return this.appMetricsRegistry;
    }

    public List<Service> getServices() {
        return this.services;
    }

    public List<GrpcFilter> getFilters() {
        return this.grpcFilters;
    }

    public List<TracingSampler> getTracingSamplers() {
        return this.tracingSamplers;
    }

    public ConfigurationFactoryFactory<T, U> getConfigurationFactoryFactory() {
        return this.configurationFactoryFactory;
    }

    public void setConfigurationFactoryFactory(ConfigurationFactoryFactory<T, U> configurationFactoryFactory) {
        this.configurationFactoryFactory = configurationFactoryFactory;
    }

    public ConfigurationSourceProvider getConfigurationSourceProvider() {
        return this.configurationSourceProvider;
    }

    public void setConfigurationSourceProvider(ConfigurationSourceProvider configurationSourceProvider) {
        this.configurationSourceProvider = configurationSourceProvider;
    }

    public ValidatorFactory getValidatorFactory() {
        return this.validatorFactory;
    }

    public void setValidatorFactory(ValidatorFactory validatorFactory) {
        this.validatorFactory = validatorFactory;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public Class<T> getConfigurationClass() {
        return this.configurationClass;
    }

    public T getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(T configuration) {
        this.configuration = configuration;
    }

    public U getConfigMap() {
        return this.configMap;
    }

    public void setConfigMap(U configMap) {
        this.configMap = configMap;
    }

    public void run(Environment environment) throws Exception {
        this.services = new ArrayList<Service>();
        this.grpcFilters = new ArrayList<GrpcFilter>();
        this.httpFilters = new ArrayList<HttpFilter>();
        this.tracingSamplers = new ArrayList<TracingSampler>();
        this.scheduledJobs = new ArrayList<ScheduledJob>();
        this.healthCheckRegistry = environment.getHealthCheckRegistry();
        for (Bundle<T, U> bundle : this.bundles) {
            bundle.run(this.configuration, this.configMap, environment);
            this.services.addAll(bundle.getServices());
            this.grpcFilters.addAll(bundle.getGrpcFilters());
            this.httpFilters.addAll(bundle.getHTTPFilters());
            this.tracingSamplers.addAll(bundle.getTracingSamplers());
            this.scheduledJobs.addAll(bundle.getScheduledJobs());
            bundle.getHealthChecks().forEach(hc -> this.healthCheckRegistry.register(hc.getClass().getSimpleName(), (HealthCheck)hc));
        }
        this.services.forEach(service -> {
            try {
                service.start();
            }
            catch (Exception e) {
                this.error("Error starting a Service : " + service.getClass().getName(), e);
                throw new RuntimeException(e);
            }
        });
        Stream.of(this.grpcFilters, this.httpFilters).flatMap(Collection::stream).forEach(filter -> {
            try {
                filter.init();
            }
            catch (Exception e) {
                this.error("Error initializing a Filter : " + filter.getClass().getName(), e);
                throw new RuntimeException(e);
            }
        });
        this.registerServicesForShutdown();
    }

    public HealthCheckRegistry getHealthCheckRegistry() {
        return this.healthCheckRegistry;
    }

    private void registerServicesForShutdown() throws Exception {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                System.out.println("*** Shutting down GJEX server since JVM is shutting down");
                Bootstrap.this.services.forEach(Service::stop);
                Bootstrap.this.grpcFilters.forEach(Filter::destroy);
                Bootstrap.this.httpFilters.forEach(Filter::destroy);
                System.out.println("*** Server shut down");
            }
        });
    }

    private void initializeConfig() {
        try {
            Pair<T, U> pair = this.parseConfiguration(this.getConfigurationFactoryFactory(), this.getConfigurationSourceProvider(), this.getValidatorFactory().getValidator(), this.getConfigPath(), this.getConfigurationClass(), this.getObjectMapper());
            this.setConfiguration((GJEXConfiguration)pair.getKey());
            this.setConfigMap((Map)pair.getValue());
        }
        catch (ConfigurationException | IOException e) {
            throw new GJEXError(GJEXError.ErrorType.runtime, "Error occurred while reading/parsing configuration from source " + this.getConfigPath(), e);
        }
    }

    private Pair<T, U> parseConfiguration(ConfigurationFactoryFactory<T, U> configurationFactoryFactory, ConfigurationSourceProvider provider, Validator validator, String configPath, Class<T> klass, ObjectMapper objectMapper) throws IOException, ConfigurationException {
        ConfigurationFactory<T, U> configurationFactory = configurationFactoryFactory.create(klass, validator, objectMapper);
        if (configPath != null) {
            return configurationFactory.build(provider, configPath);
        }
        return configurationFactory.build();
    }
}

